/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookieHandle;
import org.apache.bookkeeper.client.ClientCBWorker;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.QuorumOpMonitor;
import org.apache.bookkeeper.proto.ReadEntryCallback;
import org.apache.bookkeeper.proto.WriteCallback;
import org.apache.log4j.Logger;

public class QuorumEngine {
    static Logger LOG = Logger.getLogger(QuorumEngine.class);
    QuorumOpMonitor opMonitor;
    ClientCBWorker cbWorker;
    LedgerHandle lh;
    int qRef = 0;
    static long idCounter;

    static synchronized long getOpId() {
        return idCounter++;
    }

    public QuorumEngine(LedgerHandle lh) {
        this.lh = lh;
        this.opMonitor = new QuorumOpMonitor(lh);
        idCounter = 0L;
        LOG.debug((Object)"Creating cbWorker");
        this.cbWorker = ClientCBWorker.getInstance();
        LOG.debug((Object)"Created cbWorker");
    }

    void sendOp(Operation r) throws InterruptedException, BKException {
        switch (r.type) {
            case 0: {
                Operation.ReadOp rOp = (Operation.ReadOp)r;
                LOG.debug((Object)("Adding read operation to opMonitor: " + rOp.firstEntry + ", " + rOp.lastEntry));
                this.cbWorker.addOperation(r);
                for (long entry = rOp.firstEntry; entry <= rOp.lastEntry; ++entry) {
                    long counter = 0L;
                    QuorumOpMonitor.PendingReadOp pROp = new QuorumOpMonitor.PendingReadOp(this.lh);
                    int n = this.lh.getBookies(entry).size();
                    if (n < this.lh.getQuorumSize()) {
                        throw BKException.create(-6);
                    }
                    while (counter < (long)this.lh.getQuorumSize()) {
                        int index = (int)((entry + counter++) % (long)n);
                        try {
                            SubOp.SubReadOp sRead = new SubOp.SubReadOp(rOp, pROp, index, this.opMonitor);
                            BookieHandle bh = this.lh.getBookies(entry).get(index % n);
                            if (!bh.isEnabled()) continue;
                            bh.sendRead(this.lh, sRead, entry);
                        }
                        catch (IOException e) {
                            LOG.error((Object)e);
                        }
                    }
                }
                break;
            }
            case 1: {
                int n = this.lh.getBookies().size();
                if (n < this.lh.getQuorumSize()) {
                    throw BKException.create(-6);
                }
                long counter = 0L;
                this.cbWorker.addOperation(r);
                Operation.AddOp aOp = (Operation.AddOp)r;
                QuorumOpMonitor.PendingOp pOp = new QuorumOpMonitor.PendingOp();
                while (counter < (long)this.lh.getQuorumSize()) {
                    int index = (int)((aOp.entry + counter++) % (long)n);
                    try {
                        SubOp.SubAddOp sAdd = new SubOp.SubAddOp(aOp, pOp, index, this.opMonitor);
                        this.lh.getBookies().get(index % n).sendAdd(this.lh, sAdd, aOp.entry);
                    }
                    catch (Exception io) {
                        LOG.error((Object)("Error when sending entry: " + aOp.entry + ", " + index + ", " + io));
                        --counter;
                        n = this.lh.getBookies().size();
                    }
                }
                break;
            }
            case 2: {
                this.cbWorker.shutdown();
            }
        }
    }

    public static class SubOp {
        int bIndex;
        Operation op;

        public static class SubStopOp
        extends SubOp {
            SubStopOp(Operation op) {
                this.op = op;
            }
        }

        public static class SubReadOp
        extends SubOp {
            QuorumOpMonitor.PendingReadOp pOp;
            ReadEntryCallback rcb;

            SubReadOp(Operation op, QuorumOpMonitor.PendingReadOp pOp, int bIndex, ReadEntryCallback rcb) {
                this.op = op;
                this.pOp = pOp;
                this.bIndex = bIndex;
                this.rcb = rcb;
            }
        }

        public static class SubAddOp
        extends SubOp {
            QuorumOpMonitor.PendingOp pOp;
            WriteCallback wcb;

            SubAddOp(Operation op, QuorumOpMonitor.PendingOp pOp, int bIndex, WriteCallback wcb) {
                this.op = op;
                this.pOp = pOp;
                this.bIndex = bIndex;
                this.wcb = wcb;
            }
        }
    }

    public static class Operation {
        public static final int READ = 0;
        public static final int ADD = 1;
        public static final int STOP = 2;
        int type;
        LedgerHandle ledger;
        long id = QuorumEngine.getOpId();
        int rc = 0;
        boolean ready = false;

        long getId() {
            return this.id;
        }

        void setErrorCode(int rc) {
            this.rc = rc;
        }

        int getErrorCode() {
            return this.rc;
        }

        synchronized boolean isReady() {
            return this.ready;
        }

        synchronized void setReady() {
            this.ready = true;
            this.notify();
        }

        LedgerHandle getLedger() {
            return this.ledger;
        }

        public static class StopOp
        extends Operation {
            public StopOp() {
                this.type = 2;
            }
        }

        public static class ReadOp
        extends Operation {
            AsyncCallback.ReadCallback cb;
            Object ctx;
            long firstEntry;
            long lastEntry;
            LedgerEntry[] seq;
            AtomicInteger counter;
            HashMap<Long, AtomicInteger> nacks;

            public ReadOp(LedgerHandle ledger, long firstEntry, long lastEntry, AsyncCallback.ReadCallback cb, Object ctx) {
                this.type = 0;
                this.firstEntry = firstEntry;
                this.lastEntry = lastEntry;
                this.cb = cb;
                this.ctx = ctx;
                this.seq = new LedgerEntry[(int)(lastEntry - firstEntry + 1L)];
                this.counter = new AtomicInteger(0);
                this.nacks = new HashMap();
                this.ledger = ledger;
            }
        }

        public static class AddOp
        extends Operation {
            AsyncCallback.AddCallback cb;
            Object ctx;
            byte[] data;
            long entry;

            public AddOp(LedgerHandle ledger, byte[] data, AsyncCallback.AddCallback cb, Object ctx) {
                this.type = 1;
                this.data = data;
                this.entry = ledger.incLast();
                this.cb = cb;
                this.ctx = ctx;
                this.ledger = ledger;
            }
        }
    }
}

