/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.Mac;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookieHandle;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.QuorumEngine;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.proto.ReadEntryCallback;
import org.apache.bookkeeper.proto.WriteCallback;
import org.apache.log4j.Logger;

public class QuorumOpMonitor
implements WriteCallback,
ReadEntryCallback {
    static Logger LOG = Logger.getLogger(QuorumOpMonitor.class);
    LedgerHandle lh;
    static final int MAXRETRIES = 2;
    MessageDigest digest = null;
    int dLength;

    MessageDigest getDigestInstance(String alg) throws NoSuchAlgorithmException {
        if (this.digest == null) {
            this.digest = MessageDigest.getInstance(alg);
        }
        return this.digest;
    }

    QuorumOpMonitor(LedgerHandle lh) {
        this.lh = lh;
        try {
            this.dLength = this.getDigestInstance(lh.getDigestAlg()).getDigestLength();
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)("Problem with message digest: " + e));
            this.dLength = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeComplete(int rc, long ledgerId, long entryId, Object ctx) {
        QuorumEngine.SubOp.SubAddOp sAdd = (QuorumEngine.SubOp.SubAddOp)ctx;
        PendingOp pOp = sAdd.pOp;
        Integer sId = sAdd.bIndex;
        if (pOp == null) {
            LOG.error((Object)("No such an entry ID: " + entryId + "(" + ledgerId + ")"));
            return;
        }
        ArrayList<BookieHandle> list = this.lh.getBookies();
        if (rc == 0) {
            PendingOp pendingOp = pOp;
            synchronized (pendingOp) {
                pOp.bookieIdRecv.add(sId);
                this.lh.setLastRecvCorrectly(sId, entryId);
                if (pOp.bookieIdRecv.size() >= this.lh.getQuorumSize()) {
                    sAdd.op.setReady();
                }
            }
        }
        if (this.lh.getId() == -1L) {
            LOG.warn((Object)"Ledger identifier is not valid");
            return;
        }
        PendingOp pendingOp = pOp;
        synchronized (pendingOp) {
            pOp.bookieIdSent.add(sId);
            HashSet<Integer> ids = pOp.bookieIdSent;
            if (ids.size() == this.lh.getBookies().size()) {
                if (pOp.retries++ >= 2) {
                    sAdd.op.setErrorCode(-6);
                    sAdd.op.setReady();
                    return;
                }
                ids.clear();
            }
            try {
                if ((long)sId.intValue() >= entryId % (long)(this.lh.getBookies().size() + 1)) {
                    int bCounter = sId - (int)entryId % (this.lh.getBookies().size() + 1);
                } else {
                    int bCounter = this.lh.getBookies().size() + 1 - (int)entryId % (this.lh.getBookies().size() + 1) - sId;
                }
                int tmpId = ((int)entryId + this.lh.getQuorumSize()) % (this.lh.getBookies().size() + 1);
                int newId = tmpId % this.lh.getBookies().size();
                BookieHandle bh = this.lh.getBookies().get(newId);
                bh.sendAdd(this.lh, new QuorumEngine.SubOp.SubAddOp(sAdd.op, pOp, newId, this), entryId);
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
            catch (BKException e) {
                LOG.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readEntryComplete(int rc, long ledgerId, long entryId, ByteBuffer bb, Object ctx) {
        if (rc == 0) {
            QuorumEngine.SubOp.SubReadOp sRead = (QuorumEngine.SubOp.SubReadOp)ctx;
            QuorumEngine.Operation.ReadOp rOp = (QuorumEngine.Operation.ReadOp)sRead.op;
            PendingReadOp pOp = sRead.pOp;
            if (pOp != null) {
                HashSet received = pOp.bookieIdRecv;
                boolean result = received.add(sRead.bIndex);
                int counter = -1;
                if (result) {
                    Buffer voted = null;
                    switch (this.lh.getQMode()) {
                        case VERIFIABLE: {
                            if (rOp.seq[(int)(entryId % (rOp.lastEntry - rOp.firstEntry + 1L))] == null) {
                                try {
                                    voted = this.voteVerifiable(bb);
                                }
                                catch (NoSuchAlgorithmException e) {
                                    LOG.error((Object)("Problem with message digest: " + e));
                                }
                                catch (BKException bke) {
                                    LOG.error((Object)(bke.toString() + "( " + ledgerId + ", " + entryId + ", " + pOp.bookieIdRecv + ")"));
                                    this.countNacks((QuorumEngine.Operation.ReadOp)((QuorumEngine.SubOp.SubReadOp)ctx).op, (QuorumEngine.SubOp.SubReadOp)ctx, ledgerId, entryId);
                                }
                                catch (InvalidKeyException e) {
                                    LOG.error((Object)e);
                                }
                            }
                            if (voted == null || voted.capacity() - this.dLength <= 0) break;
                            byte[] data = new byte[voted.capacity() - this.dLength - 24];
                            ((ByteBuffer)voted).position(24);
                            ((ByteBuffer)voted).get(data, 0, data.length);
                            counter = this.addNewEntry(new LedgerEntry(ledgerId, entryId, data), rOp);
                            break;
                        }
                        case GENERIC: {
                            ArrayList<ByteBuffer> list = pOp.proposedValues;
                            Object data = list;
                            synchronized (data) {
                                if (rOp.seq[(int)(entryId % (rOp.lastEntry - rOp.firstEntry + 1L))] == null) {
                                    list.add(bb);
                                    bb.position(24);
                                    if (list.size() >= (this.lh.getQuorumSize() + 1) / 2) {
                                        voted = this.voteGeneric(list, (this.lh.getQuorumSize() + 1) / 2);
                                    }
                                }
                            }
                            if (voted == null) break;
                            LOG.debug((Object)("Voted: " + ((ByteBuffer)voted).array()));
                            data = new byte[voted.capacity() - 24];
                            ((ByteBuffer)voted).position(24);
                            ((ByteBuffer)voted).get((byte[])data, 0, ((Object)data).length);
                            counter = this.addNewEntry(new LedgerEntry(ledgerId, entryId, (byte[])data), rOp);
                            break;
                        }
                        case FREEFORM: {
                            ArrayList<ByteBuffer> list = pOp.proposedValues;
                            LOG.debug((Object)("List length before: " + list.size()));
                            Object data = list;
                            synchronized (data) {
                                if (list.size() == this.lh.getQuorumSize()) {
                                    voted = this.voteFree(list);
                                }
                            }
                            if (voted == null) break;
                            LOG.debug((Object)("Voted: " + ((ByteBuffer)voted).array()));
                            data = new byte[voted.capacity() - 24];
                            ((ByteBuffer)voted).position(24);
                            ((ByteBuffer)voted).get((byte[])data, 0, ((Object)data).length);
                            counter = this.addNewEntry(new LedgerEntry(ledgerId, entryId, ((ByteBuffer)voted).array()), rOp);
                        }
                    }
                    if ((long)counter == rOp.lastEntry - rOp.firstEntry + 1L && !sRead.op.isReady()) {
                        sRead.op.setReady();
                    }
                }
            }
        } else {
            this.countNacks((QuorumEngine.Operation.ReadOp)((QuorumEngine.SubOp.SubReadOp)ctx).op, (QuorumEngine.SubOp.SubReadOp)ctx, ledgerId, entryId);
        }
    }

    synchronized void countNacks(QuorumEngine.Operation.ReadOp rOp, QuorumEngine.SubOp.SubReadOp sRead, long ledgerId, long entryId) {
        if (!rOp.nacks.containsKey(entryId)) {
            rOp.nacks.put(entryId, new AtomicInteger(0));
        }
        if (rOp.nacks.get(entryId).incrementAndGet() >= this.lh.getThreshold()) {
            int counter = -1;
            counter = this.addNewEntry(new LedgerEntry(ledgerId, entryId, null), rOp);
            if ((long)counter == rOp.lastEntry - rOp.firstEntry + 1L && !sRead.op.isReady()) {
                sRead.op.setReady();
            }
        }
    }

    private ByteBuffer voteVerifiable(ByteBuffer bb) throws NoSuchAlgorithmException, InvalidKeyException, BKException {
        Mac mac = ((BookieClient)Thread.currentThread()).getMac("HmacSHA1", this.lh.getMacKey());
        int dlength = mac.getMacLength();
        if (bb.capacity() <= dlength) {
            LOG.warn((Object)"Something wrong with this entry, length smaller than digest length");
            return null;
        }
        byte[] data = new byte[bb.capacity() - dlength];
        bb.get(data, 0, bb.capacity() - dlength);
        byte[] sig = new byte[dlength];
        bb.position(bb.capacity() - dlength);
        bb.get(sig, 0, dlength);
        bb.rewind();
        byte[] msgDigest = mac.doFinal(data);
        if (Arrays.equals(msgDigest, sig)) {
            return bb;
        }
        LOG.error((Object)("Entry id: " + new String(msgDigest) + new String(sig)));
        throw BKException.create(-5);
    }

    private ByteBuffer voteGeneric(ArrayList<ByteBuffer> list, int threshold) {
        HashMap<ByteBuffer, Integer> map = new HashMap<ByteBuffer, Integer>();
        for (ByteBuffer bb : list) {
            if (!map.containsKey(bb)) {
                map.put(bb, new Integer(0));
            } else {
                LOG.debug((Object)"Not equal");
            }
            if (bb != null) {
                map.put(bb, (Integer)map.get(bb) + 1);
            }
            if ((Integer)map.get(bb) < threshold) continue;
            return bb;
        }
        return null;
    }

    private ByteBuffer voteFree(ArrayList<ByteBuffer> list) {
        HashMap<ByteBuffer, Integer> map = new HashMap<ByteBuffer, Integer>();
        for (ByteBuffer bb : list) {
            bb.position(24);
            if (!map.containsKey(bb)) {
                map.put(bb, 0);
            }
            map.put(bb, (Integer)map.get(bb) + 1);
            if (((Integer)map.get(bb)).intValue() != list.size()) continue;
            return bb;
        }
        return null;
    }

    private int addNewEntry(LedgerEntry le, QuorumEngine.Operation.ReadOp op) {
        long index = le.getEntryId() % (op.lastEntry - op.firstEntry + 1L);
        if (op.seq[(int)index] == null) {
            if (le.getEntry() == null) {
                LOG.warn((Object)("Ledger entry is null (" + le.getEntryId() + ")"));
            }
            op.seq[(int)index] = le;
            return op.counter.incrementAndGet();
        }
        return -1;
    }

    public static class PendingReadOp
    extends PendingOp {
        ArrayList<ByteBuffer> proposedValues = new ArrayList();

        PendingReadOp(LedgerHandle lh) {
        }
    }

    public static class PendingOp {
        HashSet<Integer> bookieIdSent = new HashSet();
        HashSet<Integer> bookieIdRecv = new HashSet();
        int retries = 0;

        PendingOp() {
        }
    }
}

