/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.bookkeeper.proto.ReadEntryCallback;
import org.apache.bookkeeper.proto.WriteCallback;
import org.apache.log4j.Logger;

public class BookieClient
extends Thread {
    Logger LOG = Logger.getLogger(BookieClient.class);
    SocketChannel sock;
    int myCounter = 0;
    ConcurrentHashMap<CompletionKey, Completion<WriteCallback>> addCompletions = new ConcurrentHashMap();
    ConcurrentHashMap<CompletionKey, Completion<ReadEntryCallback>> readCompletions = new ConcurrentHashMap();
    Semaphore completionSemaphore = new Semaphore(3000);
    MessageDigest digest = null;
    Mac mac = null;
    Semaphore running = new Semaphore(0);

    public BookieClient(InetSocketAddress addr, int recvTimeout) throws IOException, ConnectException {
        this.startConnection(addr, recvTimeout);
    }

    public BookieClient(String host, int port, int recvTimeout) throws IOException, ConnectException {
        this(new InetSocketAddress(host, port), recvTimeout);
    }

    public void startConnection(InetSocketAddress addr, int recvTimeout) throws IOException, ConnectException {
        this.sock = SocketChannel.open(addr);
        this.setDaemon(true);
        this.sock.socket().setSoTimeout(recvTimeout);
        this.sock.socket().setTcpNoDelay(true);
        this.start();
    }

    public MessageDigest getDigestInstance(String alg) throws NoSuchAlgorithmException {
        if (this.digest == null) {
            this.digest = MessageDigest.getInstance(alg);
        }
        return this.digest;
    }

    public Mac getMac(String alg, byte[] key) throws NoSuchAlgorithmException, InvalidKeyException {
        if (this.mac == null) {
            this.mac = Mac.getInstance(alg);
            this.mac.init(new SecretKeySpec(key, "HmacSHA1"));
        }
        return this.mac;
    }

    public synchronized void addEntry(long ledgerId, byte[] masterKey, long entryId, ByteBuffer entry, WriteCallback cb, Object ctx) throws IOException, InterruptedException {
        if (cb == null) {
            this.LOG.error((Object)("WriteCallback object is null: " + entryId));
        }
        this.addCompletions.put(new CompletionKey(ledgerId, entryId), new Completion<WriteCallback>(cb, ctx));
        ByteBuffer tmpEntry = ByteBuffer.allocate(entry.remaining() + 44);
        tmpEntry.position(4);
        tmpEntry.putInt(1);
        tmpEntry.put(masterKey);
        tmpEntry.putLong(ledgerId);
        tmpEntry.putLong(entryId);
        tmpEntry.put(entry);
        tmpEntry.position(0);
        tmpEntry.putInt(tmpEntry.remaining() - 4);
        tmpEntry.position(0);
        if (!this.sock.isConnected() || !this.completionSemaphore.tryAcquire(1000L, TimeUnit.MILLISECONDS)) {
            throw new IOException();
        }
        this.sock.write(tmpEntry);
    }

    public synchronized void readEntry(long ledgerId, long entryId, ReadEntryCallback cb, Object ctx) throws IOException, InterruptedException {
        this.readCompletions.put(new CompletionKey(ledgerId, entryId), new Completion<ReadEntryCallback>(cb, ctx));
        ByteBuffer tmpEntry = ByteBuffer.allocate(24);
        tmpEntry.putInt(20);
        tmpEntry.putInt(2);
        tmpEntry.putLong(ledgerId);
        tmpEntry.putLong(entryId);
        tmpEntry.position(0);
        if (!this.sock.isConnected() || !this.completionSemaphore.tryAcquire(1000L, TimeUnit.MILLISECONDS)) {
            throw new IOException();
        }
        this.sock.write(tmpEntry);
    }

    private void readFully(ByteBuffer bb) throws IOException {
        while (bb.remaining() > 0) {
            this.sock.read(bb);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        int len = -1;
        ByteBuffer lenBuffer = ByteBuffer.allocate(4);
        int type = -1;
        int rc = -1;
        try {
            block6: while (this.sock.isConnected()) {
                lenBuffer.clear();
                this.readFully(lenBuffer);
                lenBuffer.flip();
                len = lenBuffer.getInt();
                ByteBuffer bb = ByteBuffer.allocate(len);
                this.readFully(bb);
                bb.flip();
                type = bb.getInt();
                rc = bb.getInt();
                switch (type) {
                    case 1: {
                        long ledgerId = bb.getLong();
                        long entryId = bb.getLong();
                        Completion<WriteCallback> ac = this.addCompletions.remove(new CompletionKey(ledgerId, entryId));
                        this.completionSemaphore.release();
                        if (ac != null) {
                            ((WriteCallback)ac.cb).writeComplete(rc, ledgerId, entryId, ac.ctx);
                            continue block6;
                        }
                        this.LOG.error((Object)("Callback object null: " + ledgerId + " : " + entryId));
                        continue block6;
                    }
                    case 2: {
                        long ledgerId = bb.getLong();
                        long entryId = bb.getLong();
                        bb.position(24);
                        byte[] data = new byte[bb.capacity() - 24];
                        bb.get(data);
                        ByteBuffer entryData = ByteBuffer.wrap(data);
                        CompletionKey key = new CompletionKey(ledgerId, entryId);
                        Completion<ReadEntryCallback> c = this.readCompletions.containsKey(key) ? this.readCompletions.remove(key) : this.readCompletions.remove(new CompletionKey(ledgerId, -1L));
                        this.completionSemaphore.release();
                        if (c == null) continue block6;
                        ((ReadEntryCallback)c.cb).readEntryComplete(rc, ledgerId, entryId, entryData, c.ctx);
                        continue block6;
                    }
                }
                System.err.println("Got error " + rc + " for type " + type);
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)("Len = " + len + ", Type = " + type + ", rc = " + rc));
        }
        this.running.release();
    }

    public void errorOut() {
        Completion<Object> ac;
        CompletionKey key;
        this.LOG.info((Object)"Erroring out pending entries");
        Enumeration<CompletionKey> e = this.addCompletions.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement();
            ac = this.addCompletions.remove(key);
            if (ac == null) continue;
            this.completionSemaphore.release();
            ((WriteCallback)ac.cb).writeComplete(-1, key.ledgerId, key.entryId, ac.ctx);
        }
        this.LOG.info((Object)"Finished erroring out pending add entries");
        e = this.readCompletions.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement();
            ac = this.readCompletions.remove(key);
            if (ac == null) continue;
            this.completionSemaphore.release();
            ((ReadEntryCallback)ac.cb).readEntryComplete(-1, key.ledgerId, key.entryId, null, ac.ctx);
        }
        this.LOG.info((Object)"Finished erroring out pending read entries");
    }

    public void halt() {
        try {
            this.sock.close();
        }
        catch (IOException e) {
            this.LOG.warn((Object)"Exception while closing socket");
        }
        try {
            this.running.acquire();
        }
        catch (InterruptedException e) {
            this.LOG.error((Object)"Interrupted while waiting for running semaphore to acquire lock");
        }
    }

    public boolean isConnected() {
        return this.sock.isConnected();
    }

    public static void main(String[] args) throws NumberFormatException, IOException, InterruptedException {
        if (args.length != 3) {
            System.err.println("USAGE: BookieClient bookieHost port ledger#");
            return;
        }
        WriteCallback cb = new WriteCallback(){

            @Override
            public void writeComplete(int rc, long ledger, long entry, Object ctx) {
                Counter counter = (Counter)ctx;
                counter.dec();
                if (rc != 0) {
                    System.out.println("rc = " + rc + " for " + entry + "@" + ledger);
                }
            }
        };
        Counter counter = new Counter();
        byte[] hello = "hello".getBytes();
        long ledger = Long.parseLong(args[2]);
        BookieClient bc = new BookieClient(args[0], Integer.parseInt(args[1]), 5000);
        for (int i = 0; i < 100000; ++i) {
            ByteBuffer entry = ByteBuffer.allocate(100);
            entry.putLong(ledger);
            entry.putLong(i);
            entry.putInt(0);
            entry.put(hello);
            entry.flip();
            counter.inc();
            bc.addEntry(ledger, new byte[0], i, entry, cb, counter);
        }
        counter.wait(0);
        System.out.println("Total = " + counter.total());
    }

    private static class Counter {
        int i;
        int total;

        private Counter() {
        }

        synchronized void inc() {
            ++this.i;
            ++this.total;
        }

        synchronized void dec() {
            --this.i;
            this.notifyAll();
        }

        synchronized void wait(int limit) throws InterruptedException {
            while (this.i > limit) {
                this.wait();
            }
        }

        synchronized int total() {
            return this.total;
        }
    }

    private static class CompletionKey {
        long ledgerId;
        long entryId;

        CompletionKey(long ledgerId, long entryId) {
            this.ledgerId = ledgerId;
            this.entryId = entryId;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CompletionKey) || obj == null) {
                return false;
            }
            CompletionKey that = (CompletionKey)obj;
            return this.ledgerId == that.ledgerId && this.entryId == that.entryId;
        }

        public int hashCode() {
            return (int)this.ledgerId << 16 ^ (int)this.entryId;
        }
    }

    private static class Completion<T> {
        T cb;
        Object ctx;

        Completion(T cb, Object ctx) {
            this.cb = cb;
            this.ctx = ctx;
        }
    }
}

