/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.proto.NIOServerFactory;
import org.apache.bookkeeper.proto.WriteCallback;
import org.apache.log4j.Logger;

public class BookieServer
implements NIOServerFactory.PacketProcessor,
WriteCallback {
    int port;
    NIOServerFactory nioServerFactory;
    volatile boolean down = false;
    Bookie bookie;
    static Logger LOG = Logger.getLogger(BookieServer.class);

    public BookieServer(int port, File journalDirectory, File[] ledgerDirectories) {
        this.port = port;
        this.bookie = new Bookie(journalDirectory, ledgerDirectories);
    }

    public void start() throws IOException {
        this.nioServerFactory = new NIOServerFactory(this.port, this);
    }

    public void shutdown() throws InterruptedException {
        this.down = true;
        this.nioServerFactory.shutdown();
        this.bookie.shutdown();
    }

    public boolean isDown() {
        return this.down;
    }

    public void join() throws InterruptedException {
        this.nioServerFactory.join();
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        if (args.length < 3) {
            System.err.println("USAGE: BookieServer port journalDirectory ledgerDirectory [ledgerDirectory]*");
            return;
        }
        int port = Integer.parseInt(args[0]);
        File journalDirectory = new File(args[1]);
        File[] ledgerDirectory = new File[args.length - 2];
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ledgerDirectory.length; ++i) {
            ledgerDirectory[i] = new File(args[i + 2]);
            if (i != 0) {
                sb.append(',');
            }
            sb.append(ledgerDirectory[i]);
        }
        String hello = String.format("Hello, I'm your bookie, listening on port %1$s. Journals are in %2$s. Ledgers are stored in %3$s.", port, journalDirectory, sb);
        LOG.info((Object)hello);
        BookieServer bs = new BookieServer(port, journalDirectory, ledgerDirectory);
        bs.start();
        bs.join();
    }

    @Override
    public void processPacket(ByteBuffer packet, NIOServerFactory.Cnxn src) {
        int type = packet.getInt();
        switch (type) {
            case 1: {
                try {
                    byte[] masterKey = new byte[20];
                    packet.get(masterKey, 0, 20);
                    this.bookie.addEntry(packet.slice(), this, src, masterKey);
                }
                catch (IOException e) {
                    if (LOG.isTraceEnabled()) {
                        ByteBuffer bb = packet.duplicate();
                        long ledgerId = bb.getLong();
                        long entryId = bb.getLong();
                        LOG.trace((Object)("Error reading " + entryId + "@" + ledgerId), (Throwable)e);
                    }
                    ByteBuffer eio = ByteBuffer.allocate(8);
                    eio.putInt(type);
                    eio.putInt(101);
                    eio.flip();
                    src.sendResponse(new ByteBuffer[]{eio});
                }
                catch (BookieException e) {
                    ByteBuffer bb = packet.duplicate();
                    long ledgerId = bb.getLong();
                    LOG.error((Object)("Unauthorized access to ledger " + ledgerId));
                    ByteBuffer eio = ByteBuffer.allocate(8);
                    eio.putInt(type);
                    eio.putInt(102);
                    eio.flip();
                    src.sendResponse(new ByteBuffer[]{eio});
                }
                break;
            }
            case 2: {
                ByteBuffer rc;
                ByteBuffer[] rsp = new ByteBuffer[2];
                rsp[0] = rc = ByteBuffer.allocate(24);
                rc.putInt(type);
                long ledgerId = packet.getLong();
                long entryId = packet.getLong();
                LOG.debug((Object)("Received new read request: " + ledgerId + ", " + entryId));
                try {
                    rsp[1] = this.bookie.readEntry(ledgerId, entryId);
                    LOG.debug((Object)("##### Read entry ##### " + rsp[1].remaining()));
                    rc.putInt(0);
                }
                catch (Bookie.NoLedgerException e) {
                    if (LOG.isTraceEnabled()) {
                        LOG.error((Object)("Error reading " + entryId + "@" + ledgerId), (Throwable)e);
                    }
                    rc.putInt(1);
                }
                catch (Bookie.NoEntryException e) {
                    if (LOG.isTraceEnabled()) {
                        LOG.error((Object)("Error reading " + entryId + "@" + ledgerId), (Throwable)e);
                    }
                    rc.putInt(2);
                }
                catch (IOException e) {
                    if (LOG.isTraceEnabled()) {
                        LOG.error((Object)("Error reading " + entryId + "@" + ledgerId), (Throwable)e);
                    }
                    rc.putInt(101);
                }
                rc.putLong(ledgerId);
                rc.putLong(entryId);
                rc.flip();
                if (LOG.isTraceEnabled()) {
                    int rcCode = rc.getInt();
                    rc.rewind();
                    LOG.trace((Object)("Read entry rc = " + rcCode + " for " + entryId + "@" + ledgerId));
                }
                if (rsp[1] == null) {
                    rsp[1] = ByteBuffer.allocate(16);
                    rsp[1].putLong(ledgerId);
                    rsp[1].putLong(entryId);
                    rsp[1].flip();
                }
                LOG.debug((Object)("Sending response for: " + entryId + ", " + new String(rsp[1].array())));
                src.sendResponse(rsp);
                break;
            }
            default: {
                ByteBuffer badType = ByteBuffer.allocate(8);
                badType.putInt(type);
                badType.putInt(100);
                badType.flip();
                src.sendResponse(new ByteBuffer[]{packet});
            }
        }
    }

    @Override
    public void writeComplete(int rc, long ledgerId, long entryId, Object ctx) {
        NIOServerFactory.Cnxn src = (NIOServerFactory.Cnxn)ctx;
        ByteBuffer bb = ByteBuffer.allocate(24);
        bb.putInt(1);
        bb.putInt(rc);
        bb.putLong(ledgerId);
        bb.putLong(entryId);
        bb.flip();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Add entry rc = " + rc + " for " + entryId + "@" + ledgerId));
        }
        src.sendResponse(new ByteBuffer[]{bb});
    }
}

