/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnLog;

public abstract class ClientBase
extends TestCase {
    protected static final Logger LOG = Logger.getLogger(ClientBase.class);
    public static final int CONNECTION_TIMEOUT = 30000;
    static final File BASETEST = new File(System.getProperty("build.test.dir", "build"));
    protected String hostPort = "127.0.0.1:33221";
    protected NIOServerCnxn.Factory serverFactory = null;
    protected File tmpDir = null;

    public ClientBase() {
    }

    public ClientBase(String name) {
        super(name);
    }

    protected ZooKeeper createClient() throws IOException, InterruptedException {
        return this.createClient(this.hostPort);
    }

    protected ZooKeeper createClient(String hp) throws IOException, InterruptedException {
        CountdownWatcher watcher = new CountdownWatcher();
        return this.createClient(watcher, hp);
    }

    protected ZooKeeper createClient(CountdownWatcher watcher, String hp) throws IOException, InterruptedException {
        ZooKeeper zk = new ZooKeeper(hp, 20000, (Watcher)watcher);
        if (!watcher.clientConnected.await(30000L, TimeUnit.MILLISECONDS)) {
            ClientBase.fail((String)"Unable to connect to server");
        }
        return zk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean waitForServerUp(String hp, long timeout) {
        long start = System.currentTimeMillis();
        String[] split = hp.split(":");
        String host = split[0];
        int port = Integer.parseInt(split[1]);
        while (true) {
            try {
                Socket sock = new Socket(host, port);
                BufferedReader reader = null;
                try {
                    OutputStream outstream = sock.getOutputStream();
                    outstream.write("stat".getBytes());
                    outstream.flush();
                    reader = new BufferedReader(new InputStreamReader(sock.getInputStream()));
                    String line = reader.readLine();
                    if (line != null && line.startsWith("Zookeeper version:")) {
                        LOG.info((Object)"Server UP");
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    sock.close();
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                LOG.info((Object)("server " + hp + " not up " + e));
            }
            if (System.currentTimeMillis() > start + timeout) {
                return false;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForServerDown(String hp, long timeout) {
        long start = System.currentTimeMillis();
        String[] split = hp.split(":");
        String host = split[0];
        int port = Integer.parseInt(split[1]);
        while (true) {
            try {
                Socket sock = new Socket(host, port);
                try {
                    OutputStream outstream = sock.getOutputStream();
                    outstream.write("stat".getBytes());
                    outstream.flush();
                }
                finally {
                    sock.close();
                }
            }
            catch (IOException e) {
                return true;
            }
            if (System.currentTimeMillis() > start + timeout) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {}
        }
        return false;
    }

    static void verifyThreadTerminated(Thread thread, long millis) throws InterruptedException {
        thread.join(millis);
        if (thread.isAlive()) {
            LOG.error((Object)("Thread " + thread.getName() + " : " + Arrays.toString(thread.getStackTrace())));
            ClientBase.assertFalse((String)("thread " + thread.getName() + " still alive after join"), (boolean)true);
        }
    }

    public static File createTmpDir() throws IOException {
        return ClientBase.createTmpDir(BASETEST);
    }

    static File createTmpDir(File parentDir) throws IOException {
        File tmpFile = File.createTempFile("test", ".junit", parentDir);
        File tmpDir = new File(tmpFile + ".dir");
        ClientBase.assertFalse((boolean)tmpDir.exists());
        ClientBase.assertTrue((boolean)tmpDir.mkdirs());
        return tmpDir;
    }

    static NIOServerCnxn.Factory createNewServerInstance(File dataDir, NIOServerCnxn.Factory factory, String hostPort) throws IOException, InterruptedException {
        ZooKeeperServer zks = new ZooKeeperServer(dataDir, dataDir, 3000);
        int PORT = Integer.parseInt(hostPort.split(":")[1]);
        if (factory == null) {
            factory = new NIOServerCnxn.Factory(PORT);
        }
        factory.startup(zks);
        ClientBase.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + PORT, 30000L));
        return factory;
    }

    static void shutdownServerInstance(NIOServerCnxn.Factory factory, String hostPort) {
        if (factory != null) {
            factory.shutdown();
            int PORT = Integer.parseInt(hostPort.split(":")[1]);
            ClientBase.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + PORT, 30000L));
        }
    }

    public static void setupTestEnv() {
        System.setProperty("zookeeper.preAllocSize", "100");
        FileTxnLog.setPreallocSize((long)100L);
    }

    protected void setUp() throws Exception {
        LOG.info((Object)("STARTING " + this.getName()));
        this.tmpDir = ClientBase.createTmpDir(BASETEST);
        ClientBase.setupTestEnv();
        this.serverFactory = ClientBase.createNewServerInstance(this.tmpDir, this.serverFactory, this.hostPort);
        LOG.info((Object)"Client test setup finished");
    }

    protected void tearDown() throws Exception {
        LOG.info((Object)"tearDown starting");
        ClientBase.shutdownServerInstance(this.serverFactory, this.hostPort);
        if (this.tmpDir != null) {
            ClientBase.recursiveDelete(this.tmpDir);
        }
        LOG.info((Object)("FINISHED " + this.getName()));
    }

    private static boolean recursiveDelete(File d) {
        if (d.isDirectory()) {
            File[] children;
            for (File f : children = d.listFiles()) {
                ClientBase.recursiveDelete(f);
            }
        }
        return d.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verifyRootOfAllServersMatch(String hostPort) throws InterruptedException, KeeperException, IOException {
        String[] parts = hostPort.split(",");
        int[] counts = new int[parts.length];
        for (int j = 0; j < 100; ++j) {
            int[] newcounts = new int[parts.length];
            int i = 0;
            for (String hp : parts) {
                ZooKeeper zk = this.createClient(hp);
                try {
                    newcounts[i++] = zk.getChildren("/", false).size();
                }
                finally {
                    zk.close();
                }
            }
            if (Arrays.equals(newcounts, counts)) {
                LOG.info((Object)("Found match with array:" + Arrays.toString(newcounts)));
                counts = newcounts;
                break;
            }
            counts = newcounts;
            Thread.sleep(10000L);
        }
        for (int i = 1; i < parts.length; ++i) {
            ClientBase.assertEquals((String)"node count not consistent", (int)counts[i - 1], (int)counts[i]);
        }
    }

    protected static class CountdownWatcher
    implements Watcher {
        volatile CountDownLatch clientConnected = new CountDownLatch(1);

        protected CountdownWatcher() {
        }

        public void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                this.clientConnected.countDown();
            }
        }
    }

    protected class NullWatcher
    implements Watcher {
        protected NullWatcher() {
        }

        public void process(WatchedEvent event) {
        }
    }
}

