/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.util.ClientBase;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.ZooKeeperServer;

public class LocalBookKeeper {
    Logger LOG = Logger.getRootLogger();
    ConsoleAppender ca = new ConsoleAppender((Layout)new PatternLayout());
    int numberOfBookies;
    private final String HOSTPORT = "127.0.0.1:2181";
    NIOServerCnxn.Factory serverFactory;
    ZooKeeperServer zks;
    ZooKeeper zkc;
    int ZooKeeperDefaultPort = 2181;
    File ZkTmpDir;
    File[] tmpDirs;
    BookieServer[] bs;
    Integer initialPort = 5000;

    public LocalBookKeeper() {
        this.LOG.addAppender((Appender)this.ca);
        this.LOG.setLevel(Level.INFO);
        this.numberOfBookies = 3;
    }

    public LocalBookKeeper(int numberOfBookies) {
        this();
        this.numberOfBookies = numberOfBookies;
        this.LOG.info((Object)("Running " + this.numberOfBookies + " bookie(s)."));
    }

    private void runZookeeper() throws IOException {
        this.LOG.info((Object)"Starting ZK server");
        this.ZkTmpDir = File.createTempFile("zookeeper", "test");
        this.ZkTmpDir.delete();
        this.ZkTmpDir.mkdir();
        try {
            this.zks = new ZooKeeperServer(this.ZkTmpDir, this.ZkTmpDir, this.ZooKeeperDefaultPort);
            this.serverFactory = new NIOServerCnxn.Factory(this.ZooKeeperDefaultPort);
            this.serverFactory.startup(this.zks);
        }
        catch (Exception e) {
            this.LOG.fatal((Object)"Exception while instantiating ZooKeeper", (Throwable)e);
        }
        boolean b = ClientBase.waitForServerUp("127.0.0.1:2181", 30000L);
        this.LOG.debug((Object)("ZooKeeper server up: " + b));
    }

    private void initializeZookeper() {
        this.LOG.info((Object)"Instantiate ZK Client");
        try {
            this.zkc = new ZooKeeper("127.0.0.1", this.ZooKeeperDefaultPort, (Watcher)new emptyWatcher());
            this.zkc.create("/ledgers", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            this.zkc.create("/ledgers/available", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            for (int i = 0; i < this.numberOfBookies; ++i) {
                this.zkc.create("/ledgers/available/127.0.0.1:" + Integer.toString(this.initialPort + i), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        catch (KeeperException e) {
            this.LOG.fatal((Object)"Exception while creating znodes", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.LOG.fatal((Object)"Interrupted while creating znodes", (Throwable)e);
        }
        catch (IOException e) {
            this.LOG.fatal((Object)"Exception while creating znodes", (Throwable)e);
        }
    }

    private void runBookies() throws IOException {
        this.LOG.info((Object)"Starting Bookie(s)");
        this.tmpDirs = new File[this.numberOfBookies];
        this.bs = new BookieServer[this.numberOfBookies];
        for (int i = 0; i < this.numberOfBookies; ++i) {
            this.tmpDirs[i] = File.createTempFile("bookie" + Integer.toString(i), "test");
            this.tmpDirs[i].delete();
            this.tmpDirs[i].mkdir();
            this.bs[i] = new BookieServer(this.initialPort + i, this.tmpDirs[i], new File[]{this.tmpDirs[i]});
            this.bs[i].start();
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        if (args.length < 1) {
            LocalBookKeeper.usage();
            System.exit(-1);
        }
        LocalBookKeeper lb = new LocalBookKeeper(Integer.parseInt(args[0]));
        lb.runZookeeper();
        lb.initializeZookeper();
        lb.runBookies();
        while (true) {
            Thread.sleep(5000L);
        }
    }

    private static void usage() {
        System.err.println("Usage: LocalBookKeeper number-of-bookies");
    }

    class emptyWatcher
    implements Watcher {
        emptyWatcher() {
        }

        public void process(WatchedEvent event) {
        }
    }
}

