/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class OtpErlangBitstr
extends OtpErlangObject
implements Serializable,
Cloneable {
    static final long serialVersionUID = -3781009633593609217L;
    protected byte[] bin;
    protected int pad_bits;

    public OtpErlangBitstr(byte[] bin) {
        this.bin = new byte[bin.length];
        System.arraycopy(bin, 0, this.bin, 0, bin.length);
        this.pad_bits = 0;
    }

    public OtpErlangBitstr(byte[] bin, int pad_bits) {
        this.bin = new byte[bin.length];
        System.arraycopy(bin, 0, this.bin, 0, bin.length);
        this.pad_bits = pad_bits;
        this.check_bitstr(this.bin, this.pad_bits);
    }

    private void check_bitstr(byte[] bin, int pad_bits) {
        if (pad_bits < 0 || 7 < pad_bits) {
            throw new IllegalArgumentException("Padding must be in range 0..7");
        }
        if (pad_bits != 0 && bin.length == 0) {
            throw new IllegalArgumentException("Padding on zero length bitstr");
        }
        if (bin.length != 0) {
            int n = bin.length - 1;
            bin[n] = (byte)(bin[n] & ~((1 << pad_bits) - 1));
        }
    }

    public OtpErlangBitstr(OtpInputStream buf) throws OtpErlangDecodeException {
        int[] pbs = new int[]{0};
        this.bin = buf.read_bitstr(pbs);
        this.pad_bits = pbs[0];
        this.check_bitstr(this.bin, this.pad_bits);
    }

    public OtpErlangBitstr(Object o) {
        try {
            this.bin = OtpErlangBitstr.toByteArray(o);
            this.pad_bits = 0;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Object must implement Serializable");
        }
    }

    private static byte[] toByteArray(Object o) throws IOException {
        if (o == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        oos.flush();
        return baos.toByteArray();
    }

    private static Object fromByteArray(byte[] buf) {
        if (buf == null) {
            return null;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (ClassNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public byte[] binaryValue() {
        return this.bin;
    }

    public int size() {
        if (this.pad_bits == 0) {
            return this.bin.length;
        }
        if (this.bin.length == 0) {
            throw new IllegalStateException("Impossible length");
        }
        return this.bin.length - 1;
    }

    public int pad_bits() {
        return this.pad_bits;
    }

    public Object getObject() {
        if (this.pad_bits != 0) {
            return null;
        }
        return OtpErlangBitstr.fromByteArray(this.bin);
    }

    public String toString() {
        if (this.pad_bits == 0) {
            return "#Bin<" + this.bin.length + ">";
        }
        if (this.bin.length == 0) {
            throw new IllegalStateException("Impossible length");
        }
        return "#Bin<" + this.bin.length + "-" + this.pad_bits + ">";
    }

    public void encode(OtpOutputStream buf) {
        buf.write_bitstr(this.bin, this.pad_bits);
    }

    public boolean equals(Object o) {
        if (!(o instanceof OtpErlangBitstr)) {
            return false;
        }
        OtpErlangBitstr that = (OtpErlangBitstr)o;
        if (this.pad_bits != that.pad_bits) {
            return false;
        }
        int len = this.bin.length;
        if (len != that.bin.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.bin[i] == that.bin[i]) continue;
            return false;
        }
        return true;
    }

    protected int doHashCode() {
        OtpErlangObject.Hash hash = new OtpErlangObject.Hash(15);
        hash.combine(this.bin);
        hash.combine(this.pad_bits);
        return hash.valueOf();
    }

    public Object clone() {
        OtpErlangBitstr that = (OtpErlangBitstr)super.clone();
        that.bin = (byte[])this.bin.clone();
        that.pad_bits = this.pad_bits;
        return that;
    }
}

