/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;

public class OtpErlangExternalFun
extends OtpErlangObject {
    private static final long serialVersionUID = 6443965570641913886L;
    private final String module;
    private final String function;
    private final int arity;

    public OtpErlangExternalFun(String module, String function, int arity) {
        this.module = module;
        this.function = function;
        this.arity = arity;
    }

    public OtpErlangExternalFun(OtpInputStream buf) throws OtpErlangDecodeException {
        OtpErlangExternalFun f = buf.read_external_fun();
        this.module = f.module;
        this.function = f.function;
        this.arity = f.arity;
    }

    public void encode(OtpOutputStream buf) {
        buf.write_external_fun(this.module, this.function, this.arity);
    }

    public boolean equals(Object o) {
        if (!(o instanceof OtpErlangExternalFun)) {
            return false;
        }
        OtpErlangExternalFun f = (OtpErlangExternalFun)o;
        return this.module.equals(f.module) && this.function.equals(f.function) && this.arity == f.arity;
    }

    protected int doHashCode() {
        OtpErlangObject.Hash hash = new OtpErlangObject.Hash(14);
        hash.combine(this.module.hashCode(), this.function.hashCode());
        hash.combine(this.arity);
        return hash.valueOf();
    }

    public String toString() {
        return "#Fun<" + this.module + "." + this.function + "." + this.arity + ">";
    }
}

