/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import java.io.Serializable;

public class OtpErlangFun
extends OtpErlangObject
implements Serializable {
    private static final long serialVersionUID = -3423031125356706472L;
    private final OtpErlangPid pid;
    private final String module;
    private final long index;
    private final long old_index;
    private final long uniq;
    private final OtpErlangObject[] freeVars;
    private final int arity;
    private final byte[] md5;

    public OtpErlangFun(OtpInputStream buf) throws OtpErlangDecodeException {
        OtpErlangFun f = buf.read_fun();
        this.pid = f.pid;
        this.module = f.module;
        this.arity = f.arity;
        this.md5 = f.md5;
        this.index = f.index;
        this.old_index = f.old_index;
        this.uniq = f.uniq;
        this.freeVars = f.freeVars;
    }

    public OtpErlangFun(OtpErlangPid pid, String module, long index, long uniq, OtpErlangObject[] freeVars) {
        this.pid = pid;
        this.module = module;
        this.arity = -1;
        this.md5 = null;
        this.index = index;
        this.old_index = 0L;
        this.uniq = uniq;
        this.freeVars = freeVars;
    }

    public OtpErlangFun(OtpErlangPid pid, String module, int arity, byte[] md5, int index, long old_index, long uniq, OtpErlangObject[] freeVars) {
        this.pid = pid;
        this.module = module;
        this.arity = arity;
        this.md5 = md5;
        this.index = index;
        this.old_index = old_index;
        this.uniq = uniq;
        this.freeVars = freeVars;
    }

    public void encode(OtpOutputStream buf) {
        buf.write_fun(this.pid, this.module, this.old_index, this.arity, this.md5, this.index, this.uniq, this.freeVars);
    }

    public boolean equals(Object o) {
        if (!(o instanceof OtpErlangFun)) {
            return false;
        }
        OtpErlangFun f = (OtpErlangFun)o;
        if (!this.pid.equals(f.pid) || !this.module.equals(f.module) || this.arity != f.arity) {
            return false;
        }
        if (this.md5 == null ? f.md5 != null : !this.md5.equals(f.md5)) {
            return false;
        }
        if (this.index != f.index || this.uniq != f.uniq) {
            return false;
        }
        if (this.freeVars == null) {
            return f.freeVars == null;
        }
        return this.freeVars.equals(f.freeVars);
    }

    protected int doHashCode() {
        OtpErlangObject.Hash hash = new OtpErlangObject.Hash(1);
        hash.combine(this.pid.hashCode(), this.module.hashCode());
        hash.combine(this.arity);
        if (this.md5 != null) {
            hash.combine(this.md5);
        }
        hash.combine(this.index);
        hash.combine(this.uniq);
        if (this.freeVars != null) {
            for (OtpErlangObject o : this.freeVars) {
                hash.combine(o.hashCode(), 1);
            }
        }
        return hash.valueOf();
    }

    public String toString() {
        return "#Fun<" + this.module + "." + this.old_index + "." + this.uniq + ">";
    }
}

