/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

class OtpMD5 {
    static final long S11 = 7L;
    static final long S12 = 12L;
    static final long S13 = 17L;
    static final long S14 = 22L;
    static final long S21 = 5L;
    static final long S22 = 9L;
    static final long S23 = 14L;
    static final long S24 = 20L;
    static final long S31 = 4L;
    static final long S32 = 11L;
    static final long S33 = 16L;
    static final long S34 = 23L;
    static final long S41 = 6L;
    static final long S42 = 10L;
    static final long S43 = 15L;
    static final long S44 = 21L;
    private final long[] state = new long[]{1732584193L, 4023233417L, 2562383102L, 271733878L};
    private final long[] count = new long[]{0L, 0L};
    private final int[] buffer = new int[64];

    public OtpMD5() {
        for (int i = 0; i < 64; ++i) {
            this.buffer[i] = 0;
        }
    }

    private int[] to_bytes(String s) {
        char[] tmp = s.toCharArray();
        int[] ret = new int[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            ret[i] = tmp[i] & 0xFF;
        }
        return ret;
    }

    private int[] clean_bytes(int[] bytes) {
        int[] ret = new int[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            ret[i] = bytes[i] & 0xFF;
        }
        return ret;
    }

    private long shl(long what, int steps) {
        return what << steps & 0xFFFFFFFFL;
    }

    private long shr(long what, int steps) {
        return what >>> steps;
    }

    private long plus(long a, long b) {
        return a + b & 0xFFFFFFFFL;
    }

    private long not(long x) {
        return (x ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFL;
    }

    private void to_buffer(int to_start, int[] from, int from_start, int num) {
        while (num-- > 0) {
            this.buffer[to_start++] = from[from_start++];
        }
    }

    private void do_update(int[] bytes) {
        int i;
        int index = (int)(this.count[0] >>> 3 & 0x3FL);
        long inlen = bytes.length;
        long addcount = this.shl(inlen, 3);
        long partlen = 64 - index;
        this.count[0] = this.plus(this.count[0], addcount);
        if (this.count[0] < addcount) {
            this.count[1] = this.count[1] + 1L;
        }
        this.count[1] = this.plus(this.count[1], this.shr(inlen, 29));
        if (inlen >= partlen) {
            this.to_buffer(index, bytes, 0, (int)partlen);
            this.transform(this.buffer, 0);
            i = (int)partlen;
            while ((long)(i + 63) < inlen) {
                this.transform(bytes, i);
                i += 64;
            }
            index = 0;
        } else {
            i = 0;
        }
        this.to_buffer(index, bytes, i, (int)inlen - i);
    }

    private void dumpstate() {
        System.out.println("state = {" + this.state[0] + ", " + this.state[1] + ", " + this.state[2] + ", " + this.state[3] + "}");
        System.out.println("count = {" + this.count[0] + ", " + this.count[1] + "}");
        System.out.print("buffer = {");
        for (int i = 0; i < 64; ++i) {
            if (i > 0) {
                System.out.print(", ");
            }
            System.out.print(this.buffer[i]);
        }
        System.out.println("}");
    }

    private long F(long x, long y, long z) {
        return x & y | this.not(x) & z;
    }

    private long G(long x, long y, long z) {
        return x & z | y & this.not(z);
    }

    private long H(long x, long y, long z) {
        return x ^ y ^ z;
    }

    private long I(long x, long y, long z) {
        return y ^ (x | this.not(z));
    }

    private long ROTATE_LEFT(long x, long n) {
        return this.shl(x, (int)n) | this.shr(x, (int)(32L - n));
    }

    private long FF(long a, long b, long c, long d, long x, long s, long ac) {
        a = this.plus(a, this.plus(this.plus(this.F(b, c, d), x), ac));
        a = this.ROTATE_LEFT(a, s);
        return this.plus(a, b);
    }

    private long GG(long a, long b, long c, long d, long x, long s, long ac) {
        a = this.plus(a, this.plus(this.plus(this.G(b, c, d), x), ac));
        a = this.ROTATE_LEFT(a, s);
        return this.plus(a, b);
    }

    private long HH(long a, long b, long c, long d, long x, long s, long ac) {
        a = this.plus(a, this.plus(this.plus(this.H(b, c, d), x), ac));
        a = this.ROTATE_LEFT(a, s);
        return this.plus(a, b);
    }

    private long II(long a, long b, long c, long d, long x, long s, long ac) {
        a = this.plus(a, this.plus(this.plus(this.I(b, c, d), x), ac));
        a = this.ROTATE_LEFT(a, s);
        return this.plus(a, b);
    }

    private void decode(long[] output, int[] input, int in_from, int len) {
        int i = 0;
        for (int j = 0; j < len; j += 4) {
            output[i] = (long)input[j + in_from] | this.shl(input[j + in_from + 1], 8) | this.shl(input[j + in_from + 2], 16) | this.shl(input[j + in_from + 3], 24);
            ++i;
        }
    }

    private void transform(int[] block, int from) {
        long a = this.state[0];
        long b = this.state[1];
        long c = this.state[2];
        long d = this.state[3];
        long[] x = new long[16];
        this.decode(x, block, from, 64);
        a = this.FF(a, b, c, d, x[0], 7L, 3614090360L);
        d = this.FF(d, a, b, c, x[1], 12L, 3905402710L);
        c = this.FF(c, d, a, b, x[2], 17L, 606105819L);
        b = this.FF(b, c, d, a, x[3], 22L, 3250441966L);
        a = this.FF(a, b, c, d, x[4], 7L, 4118548399L);
        d = this.FF(d, a, b, c, x[5], 12L, 1200080426L);
        c = this.FF(c, d, a, b, x[6], 17L, 2821735955L);
        b = this.FF(b, c, d, a, x[7], 22L, 4249261313L);
        a = this.FF(a, b, c, d, x[8], 7L, 1770035416L);
        d = this.FF(d, a, b, c, x[9], 12L, 2336552879L);
        c = this.FF(c, d, a, b, x[10], 17L, 4294925233L);
        b = this.FF(b, c, d, a, x[11], 22L, 2304563134L);
        a = this.FF(a, b, c, d, x[12], 7L, 1804603682L);
        d = this.FF(d, a, b, c, x[13], 12L, 4254626195L);
        c = this.FF(c, d, a, b, x[14], 17L, 2792965006L);
        b = this.FF(b, c, d, a, x[15], 22L, 1236535329L);
        a = this.GG(a, b, c, d, x[1], 5L, 4129170786L);
        d = this.GG(d, a, b, c, x[6], 9L, 3225465664L);
        c = this.GG(c, d, a, b, x[11], 14L, 643717713L);
        b = this.GG(b, c, d, a, x[0], 20L, 3921069994L);
        a = this.GG(a, b, c, d, x[5], 5L, 3593408605L);
        d = this.GG(d, a, b, c, x[10], 9L, 38016083L);
        c = this.GG(c, d, a, b, x[15], 14L, 3634488961L);
        b = this.GG(b, c, d, a, x[4], 20L, 3889429448L);
        a = this.GG(a, b, c, d, x[9], 5L, 568446438L);
        d = this.GG(d, a, b, c, x[14], 9L, 3275163606L);
        c = this.GG(c, d, a, b, x[3], 14L, 4107603335L);
        b = this.GG(b, c, d, a, x[8], 20L, 1163531501L);
        a = this.GG(a, b, c, d, x[13], 5L, 2850285829L);
        d = this.GG(d, a, b, c, x[2], 9L, 4243563512L);
        c = this.GG(c, d, a, b, x[7], 14L, 1735328473L);
        b = this.GG(b, c, d, a, x[12], 20L, 2368359562L);
        a = this.HH(a, b, c, d, x[5], 4L, 4294588738L);
        d = this.HH(d, a, b, c, x[8], 11L, 2272392833L);
        c = this.HH(c, d, a, b, x[11], 16L, 1839030562L);
        b = this.HH(b, c, d, a, x[14], 23L, 4259657740L);
        a = this.HH(a, b, c, d, x[1], 4L, 2763975236L);
        d = this.HH(d, a, b, c, x[4], 11L, 1272893353L);
        c = this.HH(c, d, a, b, x[7], 16L, 4139469664L);
        b = this.HH(b, c, d, a, x[10], 23L, 3200236656L);
        a = this.HH(a, b, c, d, x[13], 4L, 681279174L);
        d = this.HH(d, a, b, c, x[0], 11L, 3936430074L);
        c = this.HH(c, d, a, b, x[3], 16L, 3572445317L);
        b = this.HH(b, c, d, a, x[6], 23L, 76029189L);
        a = this.HH(a, b, c, d, x[9], 4L, 3654602809L);
        d = this.HH(d, a, b, c, x[12], 11L, 3873151461L);
        c = this.HH(c, d, a, b, x[15], 16L, 530742520L);
        b = this.HH(b, c, d, a, x[2], 23L, 3299628645L);
        a = this.II(a, b, c, d, x[0], 6L, 4096336452L);
        d = this.II(d, a, b, c, x[7], 10L, 1126891415L);
        c = this.II(c, d, a, b, x[14], 15L, 2878612391L);
        b = this.II(b, c, d, a, x[5], 21L, 4237533241L);
        a = this.II(a, b, c, d, x[12], 6L, 1700485571L);
        d = this.II(d, a, b, c, x[3], 10L, 2399980690L);
        c = this.II(c, d, a, b, x[10], 15L, 4293915773L);
        b = this.II(b, c, d, a, x[1], 21L, 2240044497L);
        a = this.II(a, b, c, d, x[8], 6L, 1873313359L);
        d = this.II(d, a, b, c, x[15], 10L, 4264355552L);
        c = this.II(c, d, a, b, x[6], 15L, 2734768916L);
        b = this.II(b, c, d, a, x[13], 21L, 1309151649L);
        a = this.II(a, b, c, d, x[4], 6L, 4149444226L);
        d = this.II(d, a, b, c, x[11], 10L, 3174756917L);
        c = this.II(c, d, a, b, x[2], 15L, 718787259L);
        b = this.II(b, c, d, a, x[9], 21L, 3951481745L);
        this.state[0] = this.plus(this.state[0], a);
        this.state[1] = this.plus(this.state[1], b);
        this.state[2] = this.plus(this.state[2], c);
        this.state[3] = this.plus(this.state[3], d);
    }

    public void update(int[] bytes) {
        this.do_update(this.clean_bytes(bytes));
    }

    public void update(String s) {
        this.do_update(this.to_bytes(s));
    }

    private int[] encode(long[] input, int len) {
        int[] output = new int[len];
        int i = 0;
        for (int j = 0; j < len; j += 4) {
            output[j] = (int)(input[i] & 0xFFL);
            output[j + 1] = (int)(input[i] >>> 8 & 0xFFL);
            output[j + 2] = (int)(input[i] >>> 16 & 0xFFL);
            output[j + 3] = (int)(input[i] >>> 24 & 0xFFL);
            ++i;
        }
        return output;
    }

    public int[] final_bytes() {
        int[] bits = this.encode(this.count, 8);
        int index = (int)(this.count[0] >>> 3 & 0x3FL);
        int padlen = index < 56 ? 56 - index : 120 - index;
        int[] padding = new int[padlen];
        padding[0] = 128;
        for (int i = 1; i < padlen; ++i) {
            padding[i] = 0;
        }
        this.do_update(padding);
        this.do_update(bits);
        int[] digest = this.encode(this.state, 16);
        return digest;
    }
}

