/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.cache;

import java.util.HashMap;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class Cache
extends HashMap<String, Sequence> {
    private static final long serialVersionUID = 2560835928124595024L;
    private static HashMap<String, Cache> globalCache = new HashMap();

    public Cache(String name) {
        globalCache.put(name, this);
    }

    public static Cache getInstance(String name) {
        Cache cache = globalCache.get(name);
        if (cache == null) {
            cache = new Cache(name);
        }
        return cache;
    }

    @Override
    public Sequence put(String key, Sequence value) {
        Sequence v = super.put(key, value);
        return v == null ? Sequence.EMPTY_SEQUENCE : v;
    }

    public static Sequence put(String name, String key, Sequence value) {
        return Cache.getInstance(name).put(key, value);
    }

    public Sequence get(String key) {
        Sequence v = (Sequence)super.get(key);
        return v == null ? Sequence.EMPTY_SEQUENCE : v;
    }

    public static Sequence get(String name, String key) {
        return Cache.getInstance(name).get(key);
    }

    public static Sequence keys(String name) {
        ValueSequence keys = new ValueSequence();
        for (String key : Cache.getInstance(name).keySet()) {
            keys.add((Item)new StringValue(key));
        }
        return keys;
    }

    public Sequence remove(String key) {
        Sequence v = (Sequence)super.remove(key);
        return v == null ? Sequence.EMPTY_SEQUENCE : v;
    }

    public static Sequence remove(String name, String key) {
        return Cache.getInstance(name).remove(key);
    }

    public static void clear(String name) {
        Cache.getInstance(name).clear();
    }

    public static void clearGlobal() {
        globalCache.clear();
    }
}

