/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.cache;

import java.util.Properties;
import org.exist.storage.serializers.Serializer;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.xml.sax.SAXException;

public abstract class CacheBasicFunction
extends BasicFunction {
    private static final Properties OUTPUT_PROPERTIES = new Properties();

    public CacheBasicFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    protected String serialize(Sequence q) throws SAXException, XPathException {
        String tmp = "";
        Serializer serializer = this.context.getBroker().getSerializer();
        serializer.reset();
        serializer.setProperties(OUTPUT_PROPERTIES);
        SequenceIterator i = q.iterate();
        while (i.hasNext()) {
            Item item = i.nextItem();
            try {
                NodeValue node = (NodeValue)item;
                tmp = tmp + serializer.serialize(node);
            }
            catch (ClassCastException e) {
                tmp = tmp + item.getStringValue();
            }
        }
        return tmp;
    }

    static {
        OUTPUT_PROPERTIES.setProperty("indent", "no");
        OUTPUT_PROPERTIES.setProperty("omit-xml-declaration", "yes");
    }
}

