/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.cache;

import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.cache.Cache;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class CacheFunction
extends BasicFunction {
    private static final Logger logger = Logger.getLogger(CacheFunction.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("cache", "http://exist-db.org/xquery/cache", "cache"), "Get/create a cache using the specified name.", new SequenceType[]{new FunctionParameterSequenceType("name", 22, 2, "The name of the cache to get/create")}, (SequenceType)new FunctionParameterSequenceType("java-object", 100, 2, "the Java cache object with the given name."))};

    public CacheFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String name = args[0].itemAt(0).getStringValue();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Get/create cache [" + name + "]"));
        }
        return new JavaObjectValue((Object)Cache.getInstance(name));
    }
}

