/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.cache;

import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.cache.Cache;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class ClearFunction
extends BasicFunction {
    private static final Logger logger = Logger.getLogger(ClearFunction.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("clear", "http://exist-db.org/xquery/cache", "cache"), "Clear the entire cache, globally", null, new SequenceType(10, 1)), new FunctionSignature(new QName("clear", "http://exist-db.org/xquery/cache", "cache"), "Clear the identified cache", new SequenceType[]{new FunctionParameterSequenceType("cache-value", 11, 2, "Either the Java cache object or the name of the cache")}, new SequenceType(10, 1))};

    public ClearFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args.length == 0) {
            logger.info((Object)"Clearing all caches");
            Cache.clearGlobal();
        } else {
            Item item = args[0].itemAt(0);
            if (item.getType() == 22) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Clearing cache [" + item.getStringValue() + "]"));
                }
                Cache.clear(item.getStringValue());
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Clearing cache [" + ((Cache)item.toJavaObject(Cache.class)).toString() + "]"));
                }
                ((Cache)item.toJavaObject(Cache.class)).clear();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Cache cleared");
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

