/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.cache;

import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.cache.Cache;
import org.exist.xquery.modules.cache.CacheBasicFunction;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.SAXException;

public class PutFunction
extends CacheBasicFunction {
    private static final Logger logger = Logger.getLogger(PutFunction.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("put", "http://exist-db.org/xquery/cache", "cache"), "Put data with a key into the identified cache. Returns the previous value associated with the key", new SequenceType[]{new FunctionParameterSequenceType("cache-value", 11, 2, "Either the Java cache object or the name of the cache"), new FunctionParameterSequenceType("key", 12, 6, "The key to the object within the cache"), new FunctionParameterSequenceType("value", 12, 7, "The object to store within the cache")}, (SequenceType)new FunctionParameterSequenceType("previous-value", 12, 7, "the previous value associated with the key"))};

    public PutFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Item item = args[0].itemAt(0);
        Sequence value = args[2];
        try {
            String key = this.serialize(args[1]);
            if (item.getType() == 22) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("putting cache value [" + item.getStringValue() + ", " + key + "]"));
                }
                return Cache.put(item.getStringValue(), key, value);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("putting cache value [" + ((Cache)item.toJavaObject(Cache.class)).toString() + ", " + key + "]"));
            }
            return ((Cache)item.toJavaObject(Cache.class)).put(key, value);
        }
        catch (SAXException e) {
            logger.error((Object)"Error putting cache value", (Throwable)e);
            return Sequence.EMPTY_SEQUENCE;
        }
    }
}

