/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.cache;

import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.cache.Cache;
import org.exist.xquery.modules.cache.CacheBasicFunction;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.SAXException;

public class RemoveFunction
extends CacheBasicFunction {
    private static final Logger logger = Logger.getLogger(RemoveFunction.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("remove", "http://exist-db.org/xquery/cache", "cache"), "Remove data from the identified cache by the key. Returns the value that was associated with key", new SequenceType[]{new FunctionParameterSequenceType("cache-value", 11, 2, "Either the Java cache object or the name of the cache"), new FunctionParameterSequenceType("key", 12, 6, "The key to the object within the cache")}, (SequenceType)new FunctionParameterSequenceType("value", 12, 7, "the value that was associated with the key"))};

    public RemoveFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Item item = args[0].itemAt(0);
        try {
            String key = this.serialize(args[1]);
            if (item.getType() == 22) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("removing cache value [" + item.getStringValue() + ", " + key + "]"));
                }
                return Cache.remove(item.getStringValue(), key);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("removing cache value [" + ((Cache)item.toJavaObject(Cache.class)).toString() + ", " + key + "]"));
            }
            return ((Cache)item.toJavaObject(Cache.class)).remove(key);
        }
        catch (SAXException e) {
            logger.error((Object)"Error removing cache value", (Throwable)e);
            return Sequence.EMPTY_SEQUENCE;
        }
    }
}

