/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.compression;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.exist.collections.Collection;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DefaultDocumentSet;
import org.exist.dom.DocumentImpl;
import org.exist.dom.MutableDocumentSet;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.serializers.Serializer;
import org.exist.util.Base64Decoder;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Base64BinaryValueType;
import org.exist.xquery.value.BinaryValueFromInputStream;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.BinaryValueType;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class AbstractCompressFunction
extends BasicFunction {
    protected static final SequenceType SOURCES_PARAM = new FunctionParameterSequenceType("sources", 12, 6, "The sequence of URI's and/or Entrys. If a URI points to a collection then the collection, its resources and sub-collections are zipped recursively. An Entry takes the format <entry name=\"filename.ext\" type=\"collection|uri|binary|xml|text\" method=\"deflate|store\">data</entry>. The method attribute is only effective for the compression:zip function.");
    protected static final SequenceType COLLECTION_HIERARCHY_PARAM = new FunctionParameterSequenceType("use-collection-hierarchy", 23, 2, "Indicates whether the Collection hierarchy (if any) should be preserved in the zip file.");
    protected static final SequenceType STRIP_PREFIX_PARAM = new FunctionParameterSequenceType("strip-prefix", 22, 2, "This prefix is stripped from the Entrys name");

    public AbstractCompressFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    private String removeLeadingOffset(String uri, String stripOffset) {
        if (uri.startsWith(stripOffset)) {
            uri = uri.substring(stripOffset.length());
        }
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        return uri;
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        boolean useHierarchy = args[1].effectiveBooleanValue();
        String stripOffset = "";
        if (args.length == 3) {
            stripOffset = args[2].getStringValue();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream os = this.stream(baos);
        SequenceIterator i = args[0].iterate();
        while (i.hasNext()) {
            Item item = i.nextItem();
            if (item instanceof Element) {
                Element element = (Element)item;
                this.compressElement(os, element, useHierarchy, stripOffset);
                continue;
            }
            this.compressFromUri(os, ((AnyURIValue)item).toXmldbURI(), useHierarchy, stripOffset, "", null);
        }
        try {
            os.close();
        }
        catch (IOException ioe) {
            throw new XPathException((Expression)this, ioe.getMessage());
        }
        return BinaryValueFromInputStream.getInstance((BinaryValueManager)this.context, (BinaryValueType)new Base64BinaryValueType(), (InputStream)new ByteArrayInputStream(baos.toByteArray()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void compressFromUri(OutputStream os, XmldbURI uri, boolean useHierarchy, String stripOffset, String method, String resourceName) throws XPathException {
        DocumentImpl doc = null;
        try {
            doc = this.context.getBroker().getXMLResource(uri, 0);
            if (doc == null) {
                Collection col = this.context.getBroker().getCollection(uri);
                if (col == null) throw new XPathException((Expression)this, "Invalid URI: " + uri.toString());
                this.compressCollection(os, col, useHierarchy, stripOffset);
                return;
            } else {
                this.compressResource(os, doc, useHierarchy, stripOffset, method, resourceName);
            }
            return;
        }
        catch (PermissionDeniedException pde) {
            throw new XPathException((Expression)this, pde.getMessage());
        }
        catch (IOException ioe) {
            throw new XPathException((Expression)this, ioe.getMessage());
        }
        catch (SAXException saxe) {
            throw new XPathException((Expression)this, saxe.getMessage());
        }
        catch (LockException le) {
            throw new XPathException((Expression)this, le.getMessage());
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(0);
            }
        }
    }

    private void compressElement(OutputStream os, Element element, boolean useHierarchy, String stripOffset) throws XPathException {
        if (!element.getNodeName().equals("entry") && element.getNamespaceURI().length() <= 0) {
            throw new XPathException((Expression)this, "Item must be type of xs:anyURI or element enry.");
        }
        if (element.getChildNodes().getLength() > 1) {
            throw new XPathException((Expression)this, "Entry content is not valid XML fragment.");
        }
        String name = element.getAttribute("name");
        if (name == null) {
            throw new XPathException((Expression)this, "Entry must have name attribute.");
        }
        String type = element.getAttribute("type");
        if ("uri".equals(type)) {
            this.compressFromUri(os, XmldbURI.create((String)element.getFirstChild().getNodeValue()), useHierarchy, stripOffset, element.getAttribute("method"), name);
            return;
        }
        name = useHierarchy ? this.removeLeadingOffset(name, stripOffset) : name.substring(name.lastIndexOf("/") + 1);
        if ("collection".equals(type)) {
            name = name + "/";
        }
        Object entry = null;
        try {
            entry = this.newEntry(name);
            if (!"collection".equals(type)) {
                byte[] value;
                CRC32 chksum = new CRC32();
                Node content = element.getFirstChild();
                if (content == null) {
                    value = new byte[]{};
                } else if (content.getNodeType() == 3) {
                    String text = content.getNodeValue();
                    Base64Decoder dec = new Base64Decoder();
                    if ("binary".equals(type)) {
                        dec.translate((CharSequence)text);
                        value = dec.getByteArray();
                    } else {
                        value = text.getBytes();
                    }
                } else {
                    Serializer serializer = this.context.getBroker().getSerializer();
                    serializer.setUser(this.context.getUser());
                    serializer.setProperty("omit-xml-declaration", (Object)"no");
                    value = serializer.serialize((NodeValue)content).getBytes();
                }
                if (entry instanceof ZipEntry && "store".equals(element.getAttribute("method"))) {
                    ((ZipEntry)entry).setMethod(0);
                    chksum.update(value);
                    ((ZipEntry)entry).setCrc(chksum.getValue());
                    ((ZipEntry)entry).setSize(value.length);
                }
                this.putEntry(os, entry);
                os.write(value);
            }
        }
        catch (IOException ioe) {
            throw new XPathException((Expression)this, ioe.getMessage(), (Throwable)ioe);
        }
        catch (SAXException saxe) {
            throw new XPathException((Expression)this, saxe.getMessage(), (Throwable)saxe);
        }
        finally {
            if (entry != null) {
                try {
                    this.closeEntry(os);
                }
                catch (IOException ioe) {
                    throw new XPathException((Expression)this, ioe.getMessage(), (Throwable)ioe);
                }
            }
        }
    }

    private void compressResource(OutputStream os, DocumentImpl doc, boolean useHierarchy, String stripOffset, String method, String name) throws IOException, SAXException {
        Object entry = null;
        byte[] value = new byte[]{};
        CRC32 chksum = new CRC32();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (name != null) {
            entry = this.newEntry(name);
        } else if (useHierarchy) {
            String docCollection = doc.getCollection().getURI().toString();
            XmldbURI collection = XmldbURI.create((String)this.removeLeadingOffset(docCollection, stripOffset));
            entry = this.newEntry(collection.append(doc.getFileURI()).toString());
        } else {
            entry = this.newEntry(doc.getFileURI().toString());
        }
        if (doc.getResourceType() == 0) {
            Serializer serializer = this.context.getBroker().getSerializer();
            serializer.setUser(this.context.getUser());
            serializer.setProperty("omit-xml-declaration", (Object)"no");
            String strDoc = serializer.serialize(doc);
            value = strDoc.getBytes();
        } else if (doc.getResourceType() == 1) {
            InputStream is = this.context.getBroker().getBinaryResource((BinaryDocument)doc);
            byte[] data = new byte[16384];
            int len = 0;
            while ((len = is.read(data, 0, data.length)) > 0) {
                baos.write(data, 0, len);
            }
            is.close();
            value = baos.toByteArray();
        }
        if (entry instanceof ZipEntry && "store".equals(method)) {
            ((ZipEntry)entry).setMethod(0);
            chksum.update(value);
            ((ZipEntry)entry).setCrc(chksum.getValue());
            ((ZipEntry)entry).setSize(value.length);
        }
        this.putEntry(os, entry);
        os.write(value);
        this.closeEntry(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressCollection(OutputStream os, Collection col, boolean useHierarchy, String stripOffset) throws IOException, SAXException, LockException, PermissionDeniedException {
        DefaultDocumentSet childDocs = new DefaultDocumentSet();
        col.getDocuments(this.context.getBroker(), (MutableDocumentSet)childDocs);
        Iterator itChildDocs = childDocs.getDocumentIterator();
        while (itChildDocs.hasNext()) {
            DocumentImpl childDoc = (DocumentImpl)itChildDocs.next();
            childDoc.getUpdateLock().acquire(0);
            try {
                this.compressResource(os, childDoc, useHierarchy, stripOffset, "", null);
            }
            finally {
                childDoc.getUpdateLock().release(0);
            }
        }
        Iterator itChildCols = col.collectionIterator(this.context.getBroker());
        while (itChildCols.hasNext()) {
            XmldbURI childColURI = (XmldbURI)itChildCols.next();
            Collection childCol = this.context.getBroker().getCollection(col.getURI().append(childColURI));
            this.compressCollection(os, childCol, useHierarchy, stripOffset);
        }
    }

    protected abstract OutputStream stream(ByteArrayOutputStream var1);

    protected abstract Object newEntry(String var1);

    protected abstract void putEntry(Object var1, Object var2) throws IOException;

    protected abstract void closeEntry(Object var1) throws IOException;
}

