/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.compression;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.LocalCollection;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.modules.ModuleUtils;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Base64BinaryValueType;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.BinaryValueFromInputStream;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.BinaryValueType;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public abstract class AbstractExtractFunction
extends BasicFunction {
    private FunctionReference entryFilterFunction = null;
    protected Sequence filterParam = null;
    private FunctionReference entryDataFunction = null;
    protected Sequence storeParam = null;
    private Sequence contextSequence;

    public AbstractExtractFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        this.contextSequence = contextSequence;
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (!(args[1].itemAt(0) instanceof FunctionReference)) {
            throw new XPathException("No entry-filter function provided.");
        }
        this.entryFilterFunction = (FunctionReference)args[1].itemAt(0);
        FunctionSignature entryFilterFunctionSig = this.entryFilterFunction.getSignature();
        if (entryFilterFunctionSig.getArgumentCount() < 3) {
            throw new XPathException("entry-filter function must take at least 3 arguments.");
        }
        this.filterParam = args[2];
        if (!(args[3].itemAt(0) instanceof FunctionReference)) {
            throw new XPathException("No entry-data function provided.");
        }
        this.entryDataFunction = (FunctionReference)args[3].itemAt(0);
        FunctionSignature entryDataFunctionSig = this.entryDataFunction.getSignature();
        if (entryDataFunctionSig.getArgumentCount() < 3) {
            throw new XPathException("entry-data function must take at least 3 arguments");
        }
        this.storeParam = args[4];
        BinaryValue compressedData = (BinaryValue)args[0].itemAt(0);
        try {
            return this.processCompressedData(compressedData);
        }
        catch (XMLDBException e) {
            throw new XPathException((Throwable)e);
        }
    }

    protected abstract Sequence processCompressedData(BinaryValue var1) throws XPathException, XMLDBException;

    protected Sequence processCompressedEntry(String name, boolean isDirectory, InputStream is, Sequence filterParam, Sequence storeParam) throws IOException, XPathException, XMLDBException {
        Sequence entryDataFunctionResult;
        String dataType = isDirectory ? "folder" : "resource";
        Sequence[] filterParams = new Sequence[]{new StringValue(name), new StringValue(dataType), filterParam};
        Sequence entryFilterFunctionResult = this.entryFilterFunction.evalFunction(this.contextSequence, null, filterParams);
        if (BooleanValue.FALSE == entryFilterFunctionResult.itemAt(0)) {
            return Sequence.EMPTY_SEQUENCE;
        }
        Sequence uncompressedData = Sequence.EMPTY_SEQUENCE;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int read = -1;
        while ((read = is.read(buf)) != -1) {
            baos.write(buf, 0, read);
        }
        byte[] entryData = baos.toByteArray();
        if (this.entryDataFunction.getSignature().getArgumentCount() == 3) {
            Sequence[] dataParams = new Sequence[3];
            System.arraycopy(filterParams, 0, dataParams, 0, 2);
            dataParams[2] = storeParam;
            entryDataFunctionResult = this.entryDataFunction.evalFunction(this.contextSequence, null, dataParams);
            String path = entryDataFunctionResult.itemAt(0).getStringValue();
            LocalCollection root = new LocalCollection(this.context.getUser(), this.context.getBroker().getBrokerPool(), new AnyURIValue("/db").toXmldbURI(), this.context.getAccessContext());
            if (isDirectory) {
                XMLDBAbstractCollectionManipulator.createCollection((Collection)root, (String)path);
            } else {
                Resource resource;
                File file = new File(path);
                name = file.getName();
                path = file.getParent();
                LocalCollection target = path == null ? root : XMLDBAbstractCollectionManipulator.createCollection((Collection)root, (String)path);
                MimeType mime = MimeTable.getInstance().getContentTypeFor(name);
                try {
                    NodeValue content = ModuleUtils.streamToXML((XQueryContext)this.context, (InputStream)new ByteArrayInputStream(baos.toByteArray()));
                    resource = target.createResource(name, "XMLResource");
                    ContentHandler handler = ((XMLResource)resource).setContentAsSAX();
                    handler.startDocument();
                    content.toSAX(this.context.getBroker(), handler, null);
                    handler.endDocument();
                }
                catch (SAXException e) {
                    resource = target.createResource(name, "BinaryResource");
                    resource.setContent((Object)baos.toByteArray());
                }
                if (resource != null) {
                    if (mime != null) {
                        ((EXistResource)resource).setMimeType(mime.getName());
                    }
                    target.storeResource(resource);
                }
            }
        } else {
            block12: {
                try {
                    uncompressedData = ModuleUtils.streamToXML((XQueryContext)this.context, (InputStream)new ByteArrayInputStream(entryData));
                }
                catch (SAXException saxe) {
                    if (entryData.length <= 0) break block12;
                    uncompressedData = BinaryValueFromInputStream.getInstance((BinaryValueManager)this.context, (BinaryValueType)new Base64BinaryValueType(), (InputStream)new ByteArrayInputStream(entryData));
                }
            }
            Sequence[] dataParams = new Sequence[4];
            System.arraycopy(filterParams, 0, dataParams, 0, 2);
            dataParams[2] = uncompressedData;
            dataParams[3] = storeParam;
            entryDataFunctionResult = this.entryDataFunction.evalFunction(this.contextSequence, null, dataParams);
        }
        return entryDataFunctionResult;
    }
}

