/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.compression;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Base64BinaryValueType;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.BinaryValueFromInputStream;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.BinaryValueType;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class UnGZipFunction
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("ungzip", "http://exist-db.org/xquery/compression", "compression"), "UnGZip's data", new SequenceType[]{new FunctionParameterSequenceType("gzip-data", 26, 2, "The gzip data to uncompress.")}, new SequenceType(26, 3))};

    public UnGZipFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        BinaryValue bin = (BinaryValue)args[0].itemAt(0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int size;
            GZIPInputStream gzis = new GZIPInputStream(bin.getInputStream());
            byte[] b = new byte[4096];
            while ((size = gzis.read(b, 0, 4096)) != -1) {
                baos.write(b, 0, size);
            }
            baos.flush();
            baos.close();
            return BinaryValueFromInputStream.getInstance((BinaryValueManager)this.context, (BinaryValueType)new Base64BinaryValueType(), (InputStream)new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (IOException ioe) {
            throw new XPathException((Expression)this, ioe.getMessage());
        }
    }
}

