/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.compression;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.exist.dom.QName;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.compression.AbstractExtractFunction;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;
import org.xmldb.api.base.XMLDBException;

public class UnTarFunction
extends AbstractExtractFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("untar", "http://exist-db.org/xquery/compression", "compression"), "UnTar all the resources/folders from the provided data by calling user defined functions to determine what and how to store the resources/folders", new SequenceType[]{new FunctionParameterSequenceType("tar-data", 26, 2, "The tar file data"), new FunctionParameterSequenceType("entry-filter", 101, 2, "A user defined function for filtering resources from the tar file. The function takes 3 parameters e.g. user:untar-entry-filter($path as xs:string, $data-type as xs:string, $param as item()*) as xs:boolean. $data-type may be 'resource' or 'folder'. $param is a sequence with any additional parameters, for example a list of extracted files. If the return type is true() it indicates the entry should be processed and passed to the entry-data function, else the resource is skipped."), new FunctionParameterSequenceType("entry-filter-param", 12, 7, "A sequence with an additional parameters for filtering function."), new FunctionParameterSequenceType("entry-data", 101, 2, "A user defined function for storing an extracted resource from the tar file. The function takes 4 parameters e.g. user:untar-entry-data($path as xs:string, $data-type as xs:string, $data as item()?, $param as item()*). Or a user defined function wich returns path for storing an extracted resource from the tar file. The function takes 3 parameters e.g. user:entry-path($path as xs:string, $data-type as xs:string, $param as item()*) as xs:anyURI. $data-type may be 'resource' or 'folder'. $param is a sequence with any additional parameters"), new FunctionParameterSequenceType("entry-data-param", 12, 7, "A sequence with an additional parameters for storing function.")}, new SequenceType(11, 7))};

    public UnTarFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    protected Sequence processCompressedData(BinaryValue compressedData) throws XPathException, XMLDBException {
        TarArchiveInputStream tis = null;
        try {
            tis = new TarArchiveInputStream(compressedData.getInputStream());
            TarArchiveEntry entry = null;
            ValueSequence results = new ValueSequence();
            while ((entry = tis.getNextTarEntry()) != null) {
                Sequence processCompressedEntryResults = this.processCompressedEntry(entry.getName(), entry.isDirectory(), (InputStream)tis, this.filterParam, this.storeParam);
                results.addAll(processCompressedEntryResults);
            }
            ValueSequence valueSequence = results;
            return valueSequence;
        }
        catch (IOException ioe) {
            LOG.error((Object)ioe.getMessage(), (Throwable)ioe);
            throw new XPathException((Expression)this, ioe.getMessage(), (Throwable)ioe);
        }
        finally {
            if (tis != null) {
                try {
                    tis.close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)ioe.getMessage(), (Throwable)ioe);
                }
            }
        }
    }
}

