/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.compression;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.exist.dom.QName;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.compression.AbstractCompressFunction;
import org.exist.xquery.value.SequenceType;

public class ZipFunction
extends AbstractCompressFunction {
    private static final QName ZIP_FUNCTION_NAME = new QName("zip", "http://exist-db.org/xquery/compression", "compression");
    private static final String ZIP_FUNCTION_DESCRIPTION = "Zips nodes, resources and collections.";
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(ZIP_FUNCTION_NAME, "Zips nodes, resources and collections.", new SequenceType[]{SOURCES_PARAM, COLLECTION_HIERARCHY_PARAM}, new SequenceType(26, 7)), new FunctionSignature(ZIP_FUNCTION_NAME, "Zips nodes, resources and collections.", new SequenceType[]{SOURCES_PARAM, COLLECTION_HIERARCHY_PARAM, STRIP_PREFIX_PARAM}, new SequenceType(26, 7))};

    public ZipFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    protected void closeEntry(Object os) throws IOException {
        ((ZipOutputStream)os).closeEntry();
    }

    @Override
    protected Object newEntry(String name) {
        return new ZipEntry(name);
    }

    @Override
    protected void putEntry(Object os, Object entry) throws IOException {
        ((ZipOutputStream)os).putNextEntry((ZipEntry)entry);
    }

    @Override
    protected OutputStream stream(ByteArrayOutputStream baos) {
        return new ZipOutputStream((OutputStream)baos);
    }
}

