/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.counter;

import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.counter.Counters;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class CounterFunctions
extends BasicFunction {
    private Counters counters = null;
    protected static final Logger logger = Logger.getLogger(CounterFunctions.class);
    public static final FunctionSignature createCounter = new FunctionSignature(new QName("create", "http://exist-db.org/xquery/counter", "counter"), "Create a unique counter named $counter-name.", new SequenceType[]{new FunctionParameterSequenceType("counter-name", 11, 2, "Name of the counter.")}, (SequenceType)new FunctionReturnSequenceType(37, 3, "the value of the newly created counter."));
    public static final FunctionSignature createCounterAndInit = new FunctionSignature(new QName("create", "http://exist-db.org/xquery/counter", "counter"), "Create a unique counter named $counter-name and initialize it with value $init-value.", new SequenceType[]{new FunctionParameterSequenceType("counter-name", 11, 2, "Name of the counter."), new FunctionParameterSequenceType("init-value", 37, 2, "The initial value of the counter.")}, (SequenceType)new FunctionReturnSequenceType(37, 3, "the value of the newly created counter."));
    public static final FunctionSignature nextValue = new FunctionSignature(new QName("next-value", "http://exist-db.org/xquery/counter", "counter"), "Increment the counter $counter-name and return its new value.", new SequenceType[]{new FunctionParameterSequenceType("counter-name", 11, 2, "Name of the counter.")}, (SequenceType)new FunctionReturnSequenceType(37, 3, "the new value of the specified counter, or -1 if the counter does not exist."));
    public static final FunctionSignature destroyCounter = new FunctionSignature(new QName("destroy", "http://exist-db.org/xquery/counter", "counter"), "Destroy the counter named $counter-name.", new SequenceType[]{new FunctionParameterSequenceType("counter-name", 11, 2, "Name of the counter.")}, (SequenceType)new FunctionReturnSequenceType(23, 3, "boolean value true() if removal as successful, otherwise return value false()."));

    public CounterFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
        String counterDir = (String)context.getBroker().getConfiguration().getProperty("db-connection.data-dir");
        logger.debug((Object)("Counters directory: " + counterDir));
        try {
            if (this.counters == null) {
                this.counters = Counters.getInstance(counterDir);
            }
        }
        catch (EXistException ex) {
            logger.error((Object)("Unable to initialize counters. " + ex.getMessage()), (Throwable)ex);
        }
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.counters == null) {
            throw new XPathException("Counters are not initialized.");
        }
        String counterName = args[0].getStringValue();
        if (this.getSignature().equals((Object)createCounter)) {
            try {
                if (counterName.contains(";")) {
                    throw new EXistException("Invalid name for counter, character ';' is not allowed.");
                }
                return new IntegerValue(this.counters.createCounter(counterName), 37);
            }
            catch (EXistException e) {
                logger.error((Object)e.getMessage());
                return Sequence.EMPTY_SEQUENCE;
            }
        }
        if (this.getSignature().equals((Object)createCounterAndInit)) {
            try {
                Long initValue = Long.parseLong(args[1].getStringValue());
                if (counterName.contains(";")) {
                    throw new EXistException("Invalid name for counter, character ';' is not allowed.");
                }
                return new IntegerValue(this.counters.createCounter(counterName, initValue), 37);
            }
            catch (EXistException e) {
                logger.error((Object)e.getMessage());
                return Sequence.EMPTY_SEQUENCE;
            }
        }
        try {
            if (this.getSignature().equals((Object)destroyCounter)) {
                return new BooleanValue(this.counters.destroyCounter(counterName));
            }
            if (this.getSignature().equals((Object)nextValue)) {
                return new IntegerValue(this.counters.nextValue(counterName), 37);
            }
            return Sequence.EMPTY_SEQUENCE;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return Sequence.EMPTY_SEQUENCE;
        }
    }
}

