/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.counter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.backup.RawDataBackup;
import org.exist.indexing.RawBackupSupport;

public class Counters
implements RawBackupSupport {
    private static final Logger LOG = Logger.getLogger(Counters.class);
    private static volatile Counters instance;
    public static final String COUNTERSTORE = "counters";
    public static final String DELIMITER = ";";
    private File store = null;
    private Hashtable<String, Long> counters = new Hashtable();

    private Counters(String dataDir) throws EXistException {
        this.store = new File(dataDir, COUNTERSTORE);
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(this.store));
        }
        catch (FileNotFoundException e) {
            try {
                this.store.createNewFile();
                br = new BufferedReader(new FileReader(this.store));
            }
            catch (IOException e1) {
                throw new EXistException("Unable to create counter store file.");
            }
        }
        try {
            if (this.store.exists() && this.store.canRead()) {
                String line = "";
                while ((line = br.readLine()) != null) {
                    String[] tokens = line.split(DELIMITER);
                    this.counters.put(tokens[0], Long.parseLong(tokens[1]));
                }
                br.close();
            }
        }
        catch (IOException e) {
            throw new EXistException("IOException occurred when reading counter store file.");
        }
        catch (NumberFormatException e) {
            throw new EXistException("Corrupt counter store file: " + this.store.getAbsolutePath());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EXistException("Corrupt counter store file: " + this.store.getAbsolutePath());
        }
    }

    public static Counters getInstance(String dataDir) throws EXistException {
        if (instance == null) {
            LOG.debug((Object)"Initializing counters.");
            instance = new Counters(dataDir);
        }
        return instance;
    }

    public static Counters getInstance() throws EXistException {
        if (instance == null) {
            instance = Counters.getInstance(COUNTERSTORE);
        }
        return instance;
    }

    public long createCounter(String counterName) throws EXistException {
        return this.createCounter(counterName, 0L);
    }

    public synchronized long createCounter(String counterName, long initValue) throws EXistException {
        if (this.counters.containsKey(counterName)) {
            return this.counters.get(counterName);
        }
        this.counters.put(counterName, initValue);
        try {
            this.serializeTable();
        }
        catch (FileNotFoundException e) {
            throw new EXistException("Unable to save to counter store file.");
        }
        return this.counters.get(counterName);
    }

    public synchronized boolean destroyCounter(String counterName) throws EXistException {
        if (this.counters.containsKey(counterName)) {
            this.counters.remove(counterName);
            try {
                this.serializeTable();
            }
            catch (FileNotFoundException e) {
                throw new EXistException("Unable to remove counter from counter store file.");
            }
            return true;
        }
        return false;
    }

    public synchronized long nextValue(String counterName) throws EXistException {
        if (!this.counters.containsKey(counterName)) {
            return -1L;
        }
        long c = this.counters.get(counterName);
        this.counters.put(counterName, ++c);
        try {
            this.serializeTable();
        }
        catch (FileNotFoundException e) {
            throw new EXistException("Unable to save to counter store file.");
        }
        return c;
    }

    public Set<String> availableCounters() {
        return this.counters.keySet();
    }

    private synchronized void serializeTable() throws FileNotFoundException {
        PrintWriter p = new PrintWriter(this.store);
        Iterator<String> i = this.counters.keySet().iterator();
        String k = "";
        long v = 0L;
        while (i.hasNext()) {
            k = i.next();
            v = this.counters.get(k);
            p.println(k + DELIMITER + v);
        }
        p.close();
    }

    public void backupToArchive(RawDataBackup backup) throws IOException {
        int len;
        if (!this.store.exists()) {
            return;
        }
        OutputStream os = backup.newEntry(this.store.getName());
        FileInputStream is = new FileInputStream(this.store);
        byte[] buf = new byte[4096];
        while ((len = ((InputStream)is).read(buf)) > 0) {
            os.write(buf, 0, len);
        }
        ((InputStream)is).close();
        os.close();
        backup.closeEntry();
    }
}

