/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.cqlparser;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.memtree.DocumentImpl;
import org.exist.memtree.SAXAdapter;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLParseException;
import org.z3950.zing.cql.CQLParser;

public class ParseCQL
extends BasicFunction {
    private static final String OutputTypeString = "string";
    private static final String OutputTypeCQL = "CQL";
    private static final String OutputTypeXCQL = "XCQL";
    private static final Logger logger = Logger.getLogger(ParseCQL.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("parse-cql", "http://exist-db.org/xquery/cqlparser", "cqlparser"), "Parses expressions in the Contextual Query Language (SRU/CQL) v1.2, returning it back as XCQL or CQL, based on the second parameter, default is XCQL. Basic searchClauses (index relation term) can be combined with boolean operators.", new SequenceType[]{new FunctionParameterSequenceType("expression", 22, 3, "The expression to parse"), new FunctionParameterSequenceType("output-as", 22, 3, "Output as 'XCQL' or 'CQL'")}, (SequenceType)new FunctionReturnSequenceType(11, 3, "the result"));

    public ParseCQL(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence ret = Sequence.EMPTY_SEQUENCE;
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String query = args[0].getStringValue();
        String output = OutputTypeXCQL;
        if (!args[1].isEmpty()) {
            output = args[1].getStringValue();
        }
        try {
            CQLParser parser = new CQLParser(12369);
            CQLNode query_cql = parser.parse(query);
            if (output.equals(OutputTypeXCQL)) {
                String xmlContent = query_cql.toXCQL();
                if (xmlContent.length() == 0) {
                    return Sequence.EMPTY_SEQUENCE;
                }
                StringReader reader = new StringReader(xmlContent);
                SAXAdapter adapter = new SAXAdapter(this.context);
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                InputSource src = new InputSource(reader);
                SAXParser saxParser = factory.newSAXParser();
                XMLReader xr = saxParser.getXMLReader();
                xr.setContentHandler((ContentHandler)adapter);
                xr.setProperty("http://xml.org/sax/properties/lexical-handler", adapter);
                xr.parse(src);
                ret = (DocumentImpl)adapter.getDocument();
            } else {
                ret = output.equals(OutputTypeString) ? new StringValue(query_cql.toString()) : new StringValue(query_cql.toCQL());
            }
            return ret;
        }
        catch (CQLParseException e) {
            throw new XPathException((Expression)this, "An error occurred while parsing the query expression (CQLParseException): " + e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            throw new XPathException((Expression)this, "Error while parsing XML: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, "An error occurred while parsing the query expression (IOException): " + e.getMessage(), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new XPathException((Expression)this, "Error while constructing XML parser: " + e.getMessage(), (Throwable)e);
        }
    }
}

