/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.datetime;

import java.util.GregorianCalendar;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.DateValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class CountDayInMonthFunction
extends BasicFunction {
    protected static final Logger logger = Logger.getLogger(CountDayInMonthFunction.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("count-day-in-month", "http://exist-db.org/xquery/datetime", "datetime"), "Returns the count of a specific weekday in a month from the given date. For example it can tell you there are 5 Fridays in February 2008.", new SequenceType[]{new FunctionParameterSequenceType("weekday", 31, 2, "The day of the week in the range of 1 to 7 where 1 = Sunday and 7 = Saturday."), new FunctionParameterSequenceType("date", 51, 2, "The day that will identify the month to get the count of the number of occurrences of a given weekday")}, (SequenceType)new FunctionReturnSequenceType(31, 2, "The number of occurrences of the weekday in the selected month."));

    public CountDayInMonthFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        int dayOfInterest = ((IntegerValue)args[0].itemAt(0)).getInt();
        DateValue d = (DateValue)args[1].itemAt(0);
        GregorianCalendar cal = new GregorianCalendar(Locale.getDefault());
        cal.set(1, d.getPart(0));
        cal.set(2, d.getPart(1) - 1);
        cal.set(5, 1);
        cal.set(7, dayOfInterest);
        int dayOfInterestCount = 0;
        int monthOfInterest = cal.get(2);
        while (cal.get(2) == monthOfInterest) {
            ++dayOfInterestCount;
            cal.add(5, 7);
        }
        return new IntegerValue((long)dayOfInterestCount);
    }
}

