/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.datetime;

import java.util.GregorianCalendar;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.DateValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.TimeUtils;

public class DateForFunction
extends BasicFunction {
    protected static final Logger logger = Logger.getLogger(DateForFunction.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("date-for", "http://exist-db.org/xquery/datetime", "datetime"), "Returns the date for a given set of parameters.", new SequenceType[]{new FunctionParameterSequenceType("year", 31, 2, "The year of interest"), new FunctionParameterSequenceType("month", 31, 2, "The month of interest (1 = January, 12 = December)"), new FunctionParameterSequenceType("week", 31, 2, "The week in the month of interest (1 = first week, 4 or 5 = last week)"), new FunctionParameterSequenceType("weekday", 31, 2, "The day in the week of interest (1 = Sunday, 7 = Saturday)")}, (SequenceType)new FunctionReturnSequenceType(51, 2, "the date generated from the parameters."));

    public DateForFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        int yearOfInterest = ((IntegerValue)args[0].itemAt(0)).getInt();
        int monthOfInterest = ((IntegerValue)args[1].itemAt(0)).getInt();
        int weekInMonth = ((IntegerValue)args[2].itemAt(0)).getInt();
        int dayInWeek = ((IntegerValue)args[3].itemAt(0)).getInt();
        if (monthOfInterest < 1 || monthOfInterest > 12) {
            throw new XPathException((Expression)this, "The month of interest must be between 1 and 12");
        }
        if (weekInMonth < 1 || weekInMonth > 5) {
            throw new XPathException((Expression)this, "The week in the month of interest must be between 1 and 5");
        }
        if (dayInWeek < 1 || dayInWeek > 7) {
            throw new XPathException((Expression)this, "The day in the week of interest must be between 1 and 7");
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, yearOfInterest);
        cal.set(2, monthOfInterest - 1);
        cal.set(4, weekInMonth);
        cal.set(7, dayInWeek);
        return new DateValue(TimeUtils.getInstance().newXMLGregorianCalendar(cal));
    }
}

