/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.datetime;

import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AbstractDateTimeValue;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DurationValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.ValueSequence;

public class DateRangeFunctions
extends BasicFunction {
    protected static final Logger logger = Logger.getLogger(DateRangeFunctions.class);
    public static final FunctionSignature[] signature = new FunctionSignature[]{new FunctionSignature(new QName("datetime-range", "http://exist-db.org/xquery/datetime", "datetime"), "Generates a range of xs:dateTime values, incremented cumulatively by a fixed duration from a start xs:dateTime", new SequenceType[]{new FunctionParameterSequenceType("start-date-time", 50, 2, "The dateTime to start at."), new FunctionParameterSequenceType("increment", 53, 2, "The duration increment."), new FunctionParameterSequenceType("iterations", 31, 2, "The number of increments to generate.")}, (SequenceType)new FunctionReturnSequenceType(50, 7, "the range(s)")), new FunctionSignature(new QName("date-range", "http://exist-db.org/xquery/datetime", "datetime"), "Generates a range of xs:date values, incremented cumulatively by a fixed duration from a start xs:date", new SequenceType[]{new FunctionParameterSequenceType("start-date", 51, 2, "The date to start at."), new FunctionParameterSequenceType("increment", 53, 2, "The duration increment."), new FunctionParameterSequenceType("iterations", 31, 2, "The number of increments to generate.")}, (SequenceType)new FunctionReturnSequenceType(51, 7, "the range(s)")), new FunctionSignature(new QName("time-range", "http://exist-db.org/xquery/datetime", "datetime"), "Generates a range of xs:time values, incremented cumulatively by a fixed duration from a start xs:time", new SequenceType[]{new FunctionParameterSequenceType("start-time", 52, 2, "The time to start at."), new FunctionParameterSequenceType("increment", 55, 2, "The duration increment."), new FunctionParameterSequenceType("iterations", 31, 2, "The number of increments to generate.")}, (SequenceType)new FunctionReturnSequenceType(52, 7, "the range(s)"))};

    public DateRangeFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Item item = args[0].itemAt(0);
        if (!(item instanceof AbstractDateTimeValue)) {
            throw new XPathException("Function requires one of xs:dateTime, xs:date, or xs:time as first parameter.");
        }
        ValueSequence result = new ValueSequence();
        AbstractDateTimeValue d1 = (AbstractDateTimeValue)item;
        DurationValue diff = (DurationValue)args[1].itemAt(0);
        AtomicValue seq = args[2].convertTo(31);
        int count = ((NumericValue)seq.itemAt(0).convertTo(31)).getInt();
        if (count < 0) {
            count = 0;
        }
        while (count-- > 0) {
            result.add((Item)d1);
            d1 = (AbstractDateTimeValue)d1.plus((ComputableValue)diff);
        }
        return result;
    }
}

