/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.datetime;

import java.util.GregorianCalendar;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.DateValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class DaysInMonthFunction
extends BasicFunction {
    protected static final Logger logger = Logger.getLogger(DaysInMonthFunction.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("days-in-month", "http://exist-db.org/xquery/datetime", "datetime"), "Returns the number of days in the month of the date.", new SequenceType[]{new FunctionParameterSequenceType("date", 51, 2, "The date for extracting the number of days in the month component.")}, (SequenceType)new FunctionReturnSequenceType(31, 2, "the number of days in the given month."));

    public DaysInMonthFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        DateValue d = (DateValue)args[0].itemAt(0);
        GregorianCalendar cal = d.calendar.toGregorianCalendar();
        int days = cal.getActualMaximum(5);
        return new IntegerValue((long)days);
    }
}

