/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.datetime;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.TimeValue;

public class FormatTimeFunction
extends BasicFunction {
    protected static final Logger logger = Logger.getLogger(FormatTimeFunction.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("format-time", "http://exist-db.org/xquery/datetime", "datetime"), "Returns a xs:string of the xs:time formatted according to the SimpleDateFormat format.", new SequenceType[]{new FunctionParameterSequenceType("time", 52, 2, "The time to to be formatted."), new FunctionParameterSequenceType("simple-date-format", 22, 2, "The format string according to the Java java.text.SimpleDateFormat class")}, (SequenceType)new FunctionReturnSequenceType(22, 2, "the formatted time string"));

    public FormatTimeFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        TimeValue t = (TimeValue)args[0].itemAt(0);
        String timeFormat = args[1].itemAt(0).toString();
        SimpleDateFormat sdf = new SimpleDateFormat(timeFormat);
        GregorianCalendar cal = t.calendar.toGregorianCalendar();
        String formattedDate = sdf.format(cal.getTime());
        return new StringValue(formattedDate);
    }
}

