/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.datetime;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.datetime.FormatDateFunction;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.TimeUtils;
import org.exist.xquery.value.TimeValue;

public class ParseTimeFunction
extends BasicFunction {
    protected static final Logger logger = Logger.getLogger(FormatDateFunction.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("parse-time", "http://exist-db.org/xquery/datetime", "datetime"), "Returns an xs:time of the xs:string parsed according to the SimpleDateFormat format.", new SequenceType[]{new FunctionParameterSequenceType("time-string", 22, 2, "The time to to be parsed."), new FunctionParameterSequenceType("simple-date-format", 22, 2, "The format string according to the Java java.text.SimpleDateFormat class")}, (SequenceType)new FunctionReturnSequenceType(52, 2, "the parsed xs:time"));

    public ParseTimeFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String strTime = args[0].itemAt(0).toString();
        String dateFormat = args[1].itemAt(0).toString();
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        try {
            Date date = sdf.parse(strTime);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            return new TimeValue(TimeUtils.getInstance().newXMLGregorianCalendar(cal));
        }
        catch (ParseException pe) {
            throw new XPathException((Expression)this, "Could not parse time string '" + strTime + "' for format '" + dateFormat + "': " + pe.getMessage(), (Throwable)pe);
        }
    }
}

