/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.example;

import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class EchoFunction
extends BasicFunction {
    private static final Logger logger = Logger.getLogger(EchoFunction.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("echo", "http://exist-db.org/xquery/examples", "example"), "A useless example function. It just echoes the input parameters.", new SequenceType[]{new FunctionParameterSequenceType("text", 22, 7, "The text to echo")}, (SequenceType)new FunctionReturnSequenceType(22, 7, "the echoed text"));

    public EchoFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        ValueSequence result = new ValueSequence();
        SequenceIterator i = args[0].iterate();
        while (i.hasNext()) {
            String str = i.nextItem().getStringValue();
            result.add((Item)new StringValue("echo: " + str));
        }
        return result;
    }
}

