/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.exi;

import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.GrammarFactory;
import com.siemens.ct.exi.api.sax.SAXDecoder;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammar.Grammar;
import com.siemens.ct.exi.helpers.DefaultEXIFactory;
import java.io.IOException;
import java.io.InputStream;
import org.exist.dom.QName;
import org.exist.memtree.AppendingSAXAdapter;
import org.exist.memtree.MemTreeBuilder;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.exi.EXIUtils;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DecodeExiFunction
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("decode-to-xml", "http://exist-db.org/xquery/exi", "exi"), "A function which returns XML from a decoded EXI source", new SequenceType[]{new FunctionParameterSequenceType("source-exi", 26, 2, "the EXI source")}, (SequenceType)new FunctionReturnSequenceType(-1, 3, "the XML result")), new FunctionSignature(new QName("decode-to-xml", "http://exist-db.org/xquery/exi", "exi"), "A function which return XML from a schema decoded EXI source", new SequenceType[]{new FunctionParameterSequenceType("source-exi", 26, 2, "the EXI source"), new FunctionParameterSequenceType("schema-location", 11, 2, "the XSD schema location")}, (SequenceType)new FunctionReturnSequenceType(-1, 3, "the XML result"))};

    public DecodeExiFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        try {
            BinaryValue exiBinary = (BinaryValue)args[0].itemAt(0);
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            EXIFactory exiFactory = DefaultEXIFactory.newInstance();
            if (args.length > 1 && !args[1].isEmpty()) {
                Item xsdItem = args[1].itemAt(0);
                InputStream xsdInputStream = EXIUtils.getInputStream(xsdItem, this.context);
                GrammarFactory grammarFactory = GrammarFactory.newInstance();
                Grammar grammar = grammarFactory.createGrammar(xsdInputStream);
                exiFactory.setGrammar(grammar);
            }
            SAXDecoder decoder = new SAXDecoder(exiFactory);
            AppendingSAXAdapter adapter = new AppendingSAXAdapter(builder);
            decoder.setContentHandler((ContentHandler)adapter);
            decoder.parse(new InputSource(exiBinary.getInputStream()));
            NodeValue node = (NodeValue)builder.getDocument().getDocumentElement();
            return node;
        }
        catch (EXIException exie) {
            throw new XPathException((Expression)this, (ErrorCodes.ErrorCode)new ErrorCodes.JavaErrorCode(exie.getCause()), exie.getMessage());
        }
        catch (SAXException saxe) {
            throw new XPathException((Expression)this, (ErrorCodes.ErrorCode)new ErrorCodes.JavaErrorCode(saxe.getCause()), saxe.getMessage());
        }
        catch (IOException ioex) {
            throw new XPathException((Expression)this, (ErrorCodes.ErrorCode)new ErrorCodes.JavaErrorCode(ioex.getCause()), ioex.getMessage());
        }
    }
}

