/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.exi;

import com.siemens.ct.exi.exceptions.EXIException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.exist.dom.QName;
import org.exist.util.serializer.EXISerializer;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.exi.EXIUtils;
import org.exist.xquery.value.Base64BinaryValueType;
import org.exist.xquery.value.BinaryValueFromInputStream;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.BinaryValueType;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class EncodeExiFunction
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("encode-from-xml", "http://exist-db.org/xquery/exi", "exi"), "A function which returns encoded EXI from an XML source.", new SequenceType[]{new FunctionParameterSequenceType("source-xml", -1, 2, "the XML source")}, (SequenceType)new FunctionReturnSequenceType(26, 3, "the binary EXI result document")), new FunctionSignature(new QName("encode-from-xml", "http://exist-db.org/xquery/exi", "exi"), "A function which returns schema encoded EXI from an XML source.", new SequenceType[]{new FunctionParameterSequenceType("source-xml", -1, 2, "the XML source"), new FunctionParameterSequenceType("schema-location", 11, 2, "the XSD schema location")}, (SequenceType)new FunctionReturnSequenceType(26, 3, "the binary EXI result document"))};

    public EncodeExiFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            EXISerializer exiSerializer = null;
            if (args.length > 1) {
                if (!args[1].isEmpty()) {
                    Item xsdItem = args[1].itemAt(0);
                    InputStream xsdInputStream = EXIUtils.getInputStream(xsdItem, this.context);
                    exiSerializer = new EXISerializer((OutputStream)baos, xsdInputStream);
                } else {
                    exiSerializer = new EXISerializer((OutputStream)baos);
                }
            } else {
                exiSerializer = new EXISerializer((OutputStream)baos);
            }
            Item inputNode = args[0].itemAt(0);
            exiSerializer.startDocument();
            inputNode.toSAX(this.context.getBroker(), (ContentHandler)exiSerializer, new Properties());
            exiSerializer.endDocument();
            return BinaryValueFromInputStream.getInstance((BinaryValueManager)this.context, (BinaryValueType)new Base64BinaryValueType(), (InputStream)new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (IOException ioex) {
            throw new XPathException((Expression)this, ErrorCodes.FODC0002, ioex.getMessage());
        }
        catch (EXIException exie) {
            throw new XPathException((Expression)this, (ErrorCodes.ErrorCode)new ErrorCodes.JavaErrorCode(exie.getCause()), exie.getMessage());
        }
        catch (SAXException saxe) {
            throw new XPathException((Expression)this, (ErrorCodes.ErrorCode)new ErrorCodes.JavaErrorCode(saxe.getCause()), saxe.getMessage());
        }
    }
}

