/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.file;

import java.io.File;
import java.util.Date;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.memtree.MemTreeBuilder;
import org.exist.util.DirectoryScanner;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.file.FileModuleHelper;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;

public class DirectoryList
extends BasicFunction {
    private static final Logger logger = Logger.getLogger(DirectoryList.class);
    static final String NAMESPACE_URI = "http://exist-db.org/xquery/file";
    static final String PREFIX = "file";
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("directory-list", "http://exist-db.org/xquery/file", "file"), "List all files, including their file size and modification time, found in or below a directory, $directory. Files are located in the server's file system, using filename patterns, $pattern.  File pattern matching is based on code from Apache's Ant, thus following the same conventions. For example:\n\n'*.xml' matches any file ending with .xml in the current directory,\n- '**/*.xml' matches files in any directory below the specified directory.  This method is only available to the DBA role.", new SequenceType[]{new FunctionParameterSequenceType("path", 11, 2, "The base directory path or URI in the file system where the files are located."), new FunctionParameterSequenceType("pattern", 22, 2, "The file name pattern")}, (SequenceType)new FunctionReturnSequenceType(-1, 3, "a node fragment that shows all matching filenames, including their file size and modification time, and the subdirectory they were found in"))};

    public DirectoryList(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!this.context.getSubject().hasDbaRole()) {
            XPathException xPathException = new XPathException((Expression)this, "Permission denied, calling user '" + this.context.getSubject().getName() + "' must be a DBA to call this function.");
            logger.error((Object)"Invalid user", (Throwable)xPathException);
            throw xPathException;
        }
        String inputPath = args[0].getStringValue();
        File baseDir = FileModuleHelper.getFile(inputPath);
        Sequence patterns = args[1];
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Listing matching files in directory: " + baseDir));
        }
        NodeValue xmlResponse = null;
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        builder.startDocument();
        builder.startElement(new QName("list", NAMESPACE_URI, PREFIX), null);
        builder.addAttribute(new QName("directory", null, null), baseDir.toString());
        SequenceIterator i = patterns.iterate();
        while (i.hasNext()) {
            String pattern = i.nextItem().getStringValue();
            File[] scannedFiles = DirectoryScanner.scanDir((File)baseDir, (String)pattern);
            String relDir = null;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found: " + scannedFiles.length));
            }
            for (File file : scannedFiles) {
                String relPath;
                int p;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found: " + file.getAbsolutePath()));
                }
                if ((p = (relPath = file.toString().substring(baseDir.toString().length() + 1)).lastIndexOf(File.separatorChar)) >= 0) {
                    relDir = relPath.substring(0, p);
                    relDir = relDir.replace(File.separatorChar, '/');
                }
                builder.startElement(new QName(PREFIX, NAMESPACE_URI, PREFIX), null);
                builder.addAttribute(new QName("name", null, null), file.getName());
                Long sizeLong = file.length();
                String sizeString = Long.toString(sizeLong);
                String humanSize = this.getHumanSize(sizeLong, sizeString);
                builder.addAttribute(new QName("size", null, null), sizeString);
                builder.addAttribute(new QName("human-size", null, null), humanSize);
                builder.addAttribute(new QName("modified", null, null), new DateTimeValue(new Date(file.lastModified())).getStringValue());
                if (relDir != null && relDir.length() > 0) {
                    builder.addAttribute(new QName("subdir", null, null), relDir);
                }
                builder.endElement();
            }
        }
        builder.endElement();
        xmlResponse = (NodeValue)builder.getDocument().getDocumentElement();
        return xmlResponse;
    }

    private String getHumanSize(Long sizeLong, String sizeString) {
        String humanSize = "n/a";
        int sizeDigits = sizeString.length();
        if (sizeDigits < 4) {
            humanSize = Long.toString(Math.abs(sizeLong));
        } else if (sizeDigits >= 4 && sizeDigits <= 6) {
            humanSize = sizeLong < 1024L ? Long.toString(Math.abs(sizeLong)) : Math.abs(sizeLong / 1024L) + "KB";
        } else if (sizeDigits >= 7 && sizeDigits <= 9) {
            humanSize = sizeLong < 0x100000L ? Math.abs(sizeLong / 1024L) + "KB" : Math.abs(sizeLong / 0x100000L) + "MB";
        } else if (sizeDigits > 9) {
            humanSize = sizeLong < 0x40000000L ? Math.abs(sizeLong / 0x100000L) + "MB" : Math.abs(sizeLong / 0x40000000L) + "GB";
        }
        return humanSize;
    }
}

