/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.file;

import java.io.File;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.file.FileModuleHelper;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FileExists
extends BasicFunction {
    private static final Logger logger = Logger.getLogger(FileExists.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("exists", "http://exist-db.org/xquery/file", "file"), "Tests if a file or directory exists.  This method is only available to the DBA role.", new SequenceType[]{new FunctionParameterSequenceType("path", 11, 2, "The full path or URI to the file in the file system")}, (SequenceType)new FunctionReturnSequenceType(23, 2, "the boolean value true if the file exists, false otherwise"))};

    public FileExists(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!this.context.getSubject().hasDbaRole()) {
            XPathException xPathException = new XPathException((Expression)this, "Permission denied, calling user '" + this.context.getSubject().getName() + "' must be a DBA to call this function.");
            logger.error((Object)"Invalid user", (Throwable)xPathException);
            throw xPathException;
        }
        BooleanValue exists = BooleanValue.FALSE;
        String inputPath = args[0].getStringValue();
        File file = FileModuleHelper.getFile(inputPath);
        if (file.exists()) {
            exists = BooleanValue.TRUE;
        }
        return exists;
    }
}

