/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.file.FileModuleHelper;
import org.exist.xquery.value.Base64BinaryValueType;
import org.exist.xquery.value.BinaryValueFromFile;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.BinaryValueType;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FileReadBinary
extends BasicFunction {
    private static final Logger logger = Logger.getLogger(FileReadBinary.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("read-binary", "http://exist-db.org/xquery/file", "file"), "Reads the contents of a binary file.  This method is only available to the DBA role.", new SequenceType[]{new FunctionParameterSequenceType("path", 11, 2, "The directory path or URI in the file system.")}, (SequenceType)new FunctionReturnSequenceType(26, 3, "the file contents"))};

    public FileReadBinary(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!this.context.getSubject().hasDbaRole()) {
            XPathException xPathException = new XPathException((Expression)this, "Permission denied, calling user '" + this.context.getSubject().getName() + "' must be a DBA to call this function.");
            logger.error((Object)"Invalid user", (Throwable)xPathException);
            throw xPathException;
        }
        String inputPath = args[0].getStringValue();
        File file = FileModuleHelper.getFile(inputPath);
        try {
            new FileInputStream(file).getFD();
            return BinaryValueFromFile.getInstance((BinaryValueManager)this.context, (BinaryValueType)new Base64BinaryValueType(), (File)file);
        }
        catch (MalformedURLException e) {
            throw new XPathException((Expression)this, (Throwable)e);
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, (Throwable)e);
        }
    }
}

