/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.file.FileModuleHelper;
import org.exist.xquery.modules.file.UnicodeReader;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FileReadUnicode
extends BasicFunction {
    private static final Logger logger = Logger.getLogger(FileReadUnicode.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("read-unicode", "http://exist-db.org/xquery/file", "file"), "Reads the contents of a file.  Unicode BOM (Byte Order Marker) will be stripped off if found.  This method is only available to the DBA role.", new SequenceType[]{new FunctionParameterSequenceType("path", 11, 2, "The directory path or URI in the file system.")}, (SequenceType)new FunctionReturnSequenceType(22, 3, "the contents of the file")), new FunctionSignature(new QName("read-unicode", "http://exist-db.org/xquery/file", "file"), "Reads the contents of a file.  Unicode BOM (Byte Order Marker) will be stripped off if found.  This method is only available to the DBA role.", new SequenceType[]{new FunctionParameterSequenceType("path", 11, 2, "The directory path or URI in the file system."), new FunctionParameterSequenceType("encoding", 22, 2, "The file is read with the encoding specified.")}, (SequenceType)new FunctionReturnSequenceType(22, 3, "the contents of the file"))};

    public FileReadUnicode(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        StringWriter sw;
        if (!this.context.getSubject().hasDbaRole()) {
            XPathException xPathException = new XPathException((Expression)this, "Permission denied, calling user '" + this.context.getSubject().getName() + "' must be a DBA to call this function.");
            logger.error((Object)"Invalid user", (Throwable)xPathException);
            throw xPathException;
        }
        String inputPath = args[0].getStringValue();
        File file = FileModuleHelper.getFile(inputPath);
        try {
            int len;
            FileInputStream fis = new FileInputStream(file);
            UnicodeReader reader = args.length > 1 ? new UnicodeReader(fis, args[1].getStringValue()) : new UnicodeReader(fis);
            sw = new StringWriter();
            char[] buf = new char[1024];
            while ((len = reader.read(buf)) > 0) {
                sw.write(buf, 0, len);
            }
            reader.close();
            sw.close();
        }
        catch (MalformedURLException e) {
            throw new XPathException((Expression)this, (Throwable)e);
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, (Throwable)e);
        }
        return new StringValue(sw.toString());
    }
}

