/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.storage.serializers.Serializer;
import org.exist.util.serializer.Receiver;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Option;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.file.FileModuleHelper;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.SAXException;

public class SerializeToFile
extends BasicFunction {
    private static final Logger logger = Logger.getLogger(SerializeToFile.class);
    private static final String FN_SERIALIZE_LN = "serialize";
    private static final String FN_SERIALIZE_BINARY_LN = "serialize-binary";
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("serialize", "http://exist-db.org/xquery/file", "file"), "Writes the node set into a file on the file system. $parameters contains a sequence of zero or more serialization parameters specified as key=value pairs. The serialization options are the same as those recognized by \"declare option exist:serialize\". The function does NOT automatically inherit the serialization options of the XQuery it is called from.  This method is only available to the DBA role.", new SequenceType[]{new FunctionParameterSequenceType("node-set", -1, 7, "The contents to write to the file system."), new FunctionParameterSequenceType("path", 11, 2, "The full path or URI to the file"), new FunctionParameterSequenceType("parameters", 22, 7, "The serialization parameters specified as key-value pairs")}, (SequenceType)new FunctionReturnSequenceType(23, 3, "true on success - false if the specified file can not be created or is not writable.  The empty sequence is returned if the argument sequence is empty.")), new FunctionSignature(new QName("serialize", "http://exist-db.org/xquery/file", "file"), "Writes the node set into a file on the file system, optionally appending to it. $parameters contains a sequence of zero or more serialization parameters specified as key=value pairs. The serialization options are the same as those recognized by \"declare option exist:serialize\". The function does NOT automatically inherit the serialization options of the XQuery it is called from.  This method is only available to the DBA role.", new SequenceType[]{new FunctionParameterSequenceType("node-set", -1, 7, "The contents to write to the file system."), new FunctionParameterSequenceType("path", 11, 2, "The full path or URI to the file"), new FunctionParameterSequenceType("parameters", 22, 7, "The serialization parameters specified as key-value pairs"), new FunctionParameterSequenceType("append", 23, 2, "Should content be appended?")}, (SequenceType)new FunctionReturnSequenceType(23, 3, "true on success - false if the specified file can not be created or is not writable.  The empty sequence is returned if the argument sequence is empty.")), new FunctionSignature(new QName("serialize-binary", "http://exist-db.org/xquery/file", "file"), "Writes binary data into a file on the file system.  This method is only available to the DBA role.", new SequenceType[]{new FunctionParameterSequenceType("binarydata", 26, 2, "The contents to write to the file system."), new FunctionParameterSequenceType("path", 11, 2, "The full path or URI to the file")}, (SequenceType)new FunctionReturnSequenceType(23, 2, "true on success - false if the specified file can not be created or is not writable")), new FunctionSignature(new QName("serialize-binary", "http://exist-db.org/xquery/file", "file"), "Writes binary data into a file on the file system, optionally appending the content.  This method is only available to the DBA role.", new SequenceType[]{new FunctionParameterSequenceType("binarydata", 26, 2, "The contents to write to the file system."), new FunctionParameterSequenceType("path", 11, 2, "The full path or URI to the file"), new FunctionParameterSequenceType("append", 23, 2, "Should content be appended?")}, (SequenceType)new FunctionReturnSequenceType(23, 2, "true on success - false if the specified file can not be created or is not writable"))};

    public SerializeToFile(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (!this.context.getSubject().hasDbaRole()) {
            XPathException xPathException = new XPathException((Expression)this, "Permission denied, calling user '" + this.context.getSubject().getName() + "' must be a DBA to call this function.");
            logger.error((Object)"Invalid user", (Throwable)xPathException);
            throw xPathException;
        }
        String inputPath = args[1].getStringValue();
        File file = FileModuleHelper.getFile(inputPath);
        if (file.isDirectory()) {
            logger.debug((Object)("Cannot serialize file. Output file is a directory: " + file.getAbsolutePath()));
            return BooleanValue.FALSE;
        }
        if (file.exists() && !file.canWrite()) {
            logger.debug((Object)("Cannot serialize file. Cannot write to file " + file.getAbsolutePath()));
            return BooleanValue.FALSE;
        }
        if (this.isCalledAs(FN_SERIALIZE_LN)) {
            Properties outputProperties = this.parseXMLSerializationOptions(args[2].iterate());
            boolean doAppend = args.length > 3 && "true".equals(args[3].itemAt(0).getStringValue());
            this.serializeXML(args[0].iterate(), outputProperties, file, doAppend);
        } else if (this.isCalledAs(FN_SERIALIZE_BINARY_LN)) {
            boolean doAppend = args.length > 2 && "true".equals(args[2].itemAt(0).getStringValue());
            this.serializeBinary((BinaryValue)args[0].itemAt(0), file, doAppend);
        } else {
            throw new XPathException((Expression)this, "Unknown function name");
        }
        return BooleanValue.TRUE;
    }

    private Properties parseXMLSerializationOptions(SequenceIterator siSerializeParams) throws XPathException {
        Properties outputProperties = new Properties();
        outputProperties.setProperty("indent", "yes");
        outputProperties.setProperty("omit-xml-declaration", "yes");
        while (siSerializeParams.hasNext()) {
            String serializeParam = siSerializeParams.nextItem().getStringValue();
            String[] opt = Option.parseKeyValuePair((String)serializeParam);
            if (opt == null || opt.length != 2) continue;
            outputProperties.setProperty(opt[0], opt[1]);
        }
        return outputProperties;
    }

    private void serializeXML(SequenceIterator siNode, Properties outputProperties, File file, boolean doAppend) throws XPathException {
        SAXSerializer sax = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
        try {
            FileOutputStream os = new FileOutputStream(file, doAppend);
            String encoding = outputProperties.getProperty("encoding", "UTF-8");
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, encoding);
            sax.setOutput((Writer)writer, outputProperties);
            Serializer serializer = this.context.getBroker().getSerializer();
            serializer.reset();
            serializer.setProperties(outputProperties);
            serializer.setReceiver((Receiver)sax);
            sax.startDocument();
            while (siNode.hasNext()) {
                NodeValue next = (NodeValue)siNode.nextItem();
                serializer.toSAX(next);
            }
            sax.endDocument();
            ((Writer)writer).close();
        }
        catch (SAXException e) {
            throw new XPathException((Expression)this, "Cannot serialize file. A problem occurred while serializing the node set: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, "Cannot serialize file. A problem occurred while serializing the node set: " + e.getMessage(), (Throwable)e);
        }
        finally {
            SerializerPool.getInstance().returnObject((Object)sax);
        }
    }

    private void serializeBinary(BinaryValue binary, File file, boolean doAppend) throws XPathException {
        try {
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file, doAppend));
            binary.streamBinaryTo((OutputStream)fos);
            ((OutputStream)fos).flush();
            ((OutputStream)fos).close();
        }
        catch (FileNotFoundException fnfe) {
            throw new XPathException((Expression)this, "Cannot serialize file. A problem occurred while serializing the binary data: " + fnfe.getMessage(), (Throwable)fnfe);
        }
        catch (IOException ioe) {
            throw new XPathException((Expression)this, "Cannot serialize file. A problem occurred while serializing the binary data: " + ioe.getMessage(), (Throwable)ioe);
        }
    }
}

