/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import org.exist.collections.Collection;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.dom.QName;
import org.exist.memtree.MemTreeBuilder;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.serializers.Serializer;
import org.exist.util.serializer.Receiver;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.file.FileModuleHelper;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.SAXException;

public class Sync
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("sync", "http://exist-db.org/xquery/file", "file"), "Synchronize a collection with a directory hierarchy. Compares last modified time stamps. If $dateTime is given, only resources modified after this time stamp are taken into account. This method is only available to the DBA role.", new SequenceType[]{new FunctionParameterSequenceType("collection", 22, 2, "The collection to sync."), new FunctionParameterSequenceType("targetPath", 11, 2, "The full path or URI to the directory"), new FunctionParameterSequenceType("dateTime", 50, 3, "Optional: only resources modified after the given date/time will be synchronized.")}, (SequenceType)new FunctionReturnSequenceType(23, 2, "true if successful, false otherwise"));
    private static final Properties DEFAULT_PROPERTIES = new Properties();

    public Sync(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!this.context.getSubject().hasDbaRole()) {
            throw new XPathException((Expression)this, "Function file:sync is only available to the DBA role");
        }
        String collectionPath = args[0].getStringValue();
        Date startDate = null;
        if (args[2].hasOne()) {
            DateTimeValue dtv = (DateTimeValue)args[2].itemAt(0);
            startDate = dtv.getDate();
        }
        String target = args[1].getStringValue();
        File targetDir = FileModuleHelper.getFile(target);
        this.context.pushDocumentContext();
        MemTreeBuilder output = this.context.getDocumentBuilder();
        try {
            if (!targetDir.isAbsolute()) {
                File home = this.context.getBroker().getConfiguration().getExistHome();
                targetDir = new File(home, target);
            }
            output.startDocument();
            output.startElement(new QName("sync", "http://exist-db.org/xquery/file"), null);
            output.addAttribute(new QName("collection", "http://exist-db.org/xquery/file"), collectionPath);
            output.addAttribute(new QName("dir", "http://exist-db.org/xquery/file"), targetDir.getAbsolutePath());
            this.saveCollection(XmldbURI.create((String)collectionPath), targetDir, startDate, output);
            output.endElement();
            output.endDocument();
        }
        catch (PermissionDeniedException pde) {
            throw new XPathException((Expression)this, (Throwable)pde);
        }
        finally {
            this.context.popDocumentContext();
        }
        return output.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCollection(XmldbURI collectionPath, File targetDir, Date startDate, MemTreeBuilder output) throws PermissionDeniedException {
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            this.reportError(output, "Failed to create output directory: " + targetDir.getAbsolutePath() + " for collection " + collectionPath);
            return;
        }
        if (!targetDir.canWrite()) {
            this.reportError(output, "Failed to write to output directory: " + targetDir.getAbsolutePath());
            return;
        }
        ArrayList subcollections = null;
        Collection collection = null;
        try {
            collection = this.context.getBroker().openCollection(collectionPath, 0);
            if (collection == null) {
                this.reportError(output, "Collection not found: " + collectionPath);
                return;
            }
            Iterator i = collection.iterator(this.context.getBroker());
            while (i.hasNext()) {
                DocumentImpl doc = (DocumentImpl)i.next();
                if (startDate != null && doc.getMetadata().getLastModified() <= startDate.getTime()) continue;
                if (doc.getResourceType() == 1) {
                    this.saveBinary(targetDir, (BinaryDocument)doc, output);
                    continue;
                }
                this.saveXML(targetDir, doc, output);
            }
            subcollections = new ArrayList(collection.getChildCollectionCount(this.context.getBroker()));
            i = collection.collectionIterator(this.context.getBroker());
            while (i.hasNext()) {
                subcollections.add(i.next());
            }
        }
        finally {
            if (collection != null) {
                collection.getLock().release(0);
            }
        }
        for (XmldbURI childURI : subcollections) {
            File childDir = new File(targetDir, childURI.lastSegment().toString());
            this.saveCollection(collectionPath.append(childURI), childDir, startDate, output);
        }
    }

    private void reportError(MemTreeBuilder output, String msg) {
        output.startElement(new QName("error", "http://exist-db.org/xquery/file"), null);
        output.characters((CharSequence)msg);
        output.endElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveXML(File targetDir, DocumentImpl doc, MemTreeBuilder output) {
        File targetFile = new File(targetDir, doc.getFileURI().toASCIIString());
        if (targetFile.exists() && targetFile.lastModified() >= doc.getMetadata().getLastModified()) {
            return;
        }
        SAXSerializer sax = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
        try {
            output.startElement(new QName("update", "http://exist-db.org/xquery/file"), null);
            output.addAttribute(new QName("file"), targetFile.getAbsolutePath());
            output.addAttribute(new QName("name"), doc.getFileURI().toString());
            output.addAttribute(new QName("collection"), doc.getCollection().getURI().toString());
            output.addAttribute(new QName("type"), "xml");
            output.addAttribute(new QName("modified"), new DateTimeValue(new Date(doc.getMetadata().getLastModified())).getStringValue());
            FileOutputStream os = new FileOutputStream(targetFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, "UTF-8");
            sax.setOutput((Writer)writer, DEFAULT_PROPERTIES);
            Serializer serializer = this.context.getBroker().getSerializer();
            serializer.reset();
            serializer.setProperties(DEFAULT_PROPERTIES);
            serializer.setReceiver((Receiver)sax);
            serializer.toSAX(doc);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            this.reportError(output, "IO error while saving file: " + targetFile.getAbsolutePath());
        }
        catch (SAXException e) {
            this.reportError(output, "SAX exception while saving file " + targetFile.getAbsolutePath() + ": " + e.getMessage());
        }
        catch (XPathException e) {
            this.reportError(output, e.getMessage());
        }
        finally {
            output.endElement();
            SerializerPool.getInstance().returnObject((Object)sax);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveBinary(File targetDir, BinaryDocument binary, MemTreeBuilder output) {
        File targetFile = new File(targetDir, binary.getFileURI().toASCIIString());
        if (targetFile.exists() && targetFile.lastModified() >= binary.getMetadata().getLastModified()) {
            return;
        }
        try {
            int c;
            output.startElement(new QName("update", "http://exist-db.org/xquery/file"), null);
            output.addAttribute(new QName("file"), targetFile.getAbsolutePath());
            output.addAttribute(new QName("name"), binary.getFileURI().toString());
            output.addAttribute(new QName("collection"), binary.getCollection().getURI().toString());
            output.addAttribute(new QName("type"), "binary");
            output.addAttribute(new QName("modified"), new DateTimeValue(new Date(binary.getMetadata().getLastModified())).getStringValue());
            FileOutputStream os = new FileOutputStream(targetFile);
            InputStream is = this.context.getBroker().getBinaryResource(binary);
            byte[] buf = new byte[4096];
            while ((c = is.read(buf)) > -1) {
                ((OutputStream)os).write(buf, 0, c);
            }
            ((OutputStream)os).close();
            is.close();
        }
        catch (IOException e) {
            this.reportError(output, "IO error while saving file: " + targetFile.getAbsolutePath());
        }
        catch (XPathException e) {
            this.reportError(output, e.getMessage());
        }
        finally {
            output.endElement();
        }
    }

    static {
        DEFAULT_PROPERTIES.put("indent", "yes");
        DEFAULT_PROPERTIES.put("omit-xml-declaration", "no");
    }
}

