/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.ftpclient;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.log4j.Logger;
import org.exist.xquery.AbstractInternalModule;
import org.exist.xquery.FunctionDef;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.ModuleUtils;
import org.exist.xquery.modules.ftpclient.GetConnectionFunction;
import org.exist.xquery.modules.ftpclient.GetDirListFunction;
import org.exist.xquery.modules.ftpclient.GetFileFunction;
import org.exist.xquery.modules.ftpclient.SendFileFunction;

public class FTPClientModule
extends AbstractInternalModule {
    public static final String NAMESPACE_URI = "http://exist-db.org/xquery/ftpclient";
    public static final String PREFIX = "ftpclient";
    public static final String INCLUSION_DATE = "2011-03-24";
    public static final String RELEASED_IN_VERSION = "eXist-1.2";
    public static final String CONNECTIONS_CONTEXTVAR = "_eXist_ftp_connections";
    private static final Logger log = Logger.getLogger(FTPClientModule.class);
    private static final FunctionDef[] functions = new FunctionDef[]{new FunctionDef(GetConnectionFunction.signatures[0], GetConnectionFunction.class), new FunctionDef(GetDirListFunction.signature, GetDirListFunction.class), new FunctionDef(SendFileFunction.signature, SendFileFunction.class), new FunctionDef(GetFileFunction.signature, GetFileFunction.class)};

    public FTPClientModule(Map<String, List<? extends Object>> parameters) {
        super(functions, parameters);
    }

    public String getNamespaceURI() {
        return NAMESPACE_URI;
    }

    public String getDefaultPrefix() {
        return PREFIX;
    }

    public String getDescription() {
        return "A module for performing FTP requests as a client";
    }

    public String getReleaseVersion() {
        return RELEASED_IN_VERSION;
    }

    public static synchronized long storeConnection(XQueryContext context, FTPClient ftp) {
        return ModuleUtils.storeObjectInContextMap((XQueryContext)context, (String)CONNECTIONS_CONTEXTVAR, (Object)ftp);
    }

    public static FTPClient retrieveConnection(XQueryContext context, long connectionUID) {
        return (FTPClient)ModuleUtils.retrieveObjectFromContextMap((XQueryContext)context, (String)CONNECTIONS_CONTEXTVAR, (long)connectionUID);
    }

    public void reset(XQueryContext xqueryContext) {
        super.reset(xqueryContext);
        FTPClientModule.closeAllConnections(xqueryContext);
    }

    private static void closeAllConnections(XQueryContext xqueryContext) {
        ModuleUtils.modifyContextMap((XQueryContext)xqueryContext, (String)CONNECTIONS_CONTEXTVAR, (ModuleUtils.ContextMapModifier)new ModuleUtils.ContextMapEntryModifier<FTPClient>(){

            public void modify(Map<Long, FTPClient> map) {
                super.modify(map);
                map.clear();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void modify(Map.Entry<Long, FTPClient> entry) {
                FTPClient con = entry.getValue();
                try {
                    con.logout();
                }
                catch (IOException ioe) {
                    log.error((Object)ioe.getMessage(), (Throwable)ioe);
                }
                finally {
                    if (con.isConnected()) {
                        try {
                            con.disconnect();
                        }
                        catch (IOException ioe) {
                            log.error((Object)ioe.getMessage(), (Throwable)ioe);
                        }
                    }
                }
            }
        });
    }
}

