/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.ftpclient;

import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.ftpclient.FTPClientModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class GetConnectionFunction
extends BasicFunction {
    private static final FunctionReturnSequenceType RETURN_TYPE = new FunctionReturnSequenceType(37, 3, "an xs:long representing the connection handle");
    private static final FunctionParameterSequenceType FTP_PASSWORD_PARAM = new FunctionParameterSequenceType("password", 22, 2, "The FTP server password");
    private static final FunctionParameterSequenceType FTP_USERNAME_PARAM = new FunctionParameterSequenceType("username", 22, 2, "The FTP server username");
    private static final FunctionParameterSequenceType FTP_HOST_PARAM = new FunctionParameterSequenceType("host", 22, 2, "The host to connect to");
    private static final Logger log = Logger.getLogger(GetConnectionFunction.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("get-connection", "http://exist-db.org/xquery/ftpclient", "ftpclient"), "Opens a connection to a SQL Database", new SequenceType[]{FTP_HOST_PARAM, FTP_USERNAME_PARAM, FTP_PASSWORD_PARAM}, (SequenceType)RETURN_TYPE)};

    public GetConnectionFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result;
        block6: {
            result = Sequence.EMPTY_SEQUENCE;
            String host = args[0].getStringValue();
            String username = args[1].getStringValue();
            String password = args[2].getStringValue();
            FTPClient ftp = new FTPClient();
            try {
                ftp.connect(host);
                log.debug((Object)("Connected to: " + host + ". " + ftp.getReplyString()));
                int reply = ftp.getReplyCode();
                if (!FTPReply.isPositiveCompletion((int)reply)) {
                    ftp.disconnect();
                    log.warn((Object)"FTP server refused connection.");
                } else {
                    result = new IntegerValue(FTPClientModule.storeConnection(this.context, ftp));
                }
            }
            catch (IOException se) {
                if (!ftp.isConnected()) break block6;
                try {
                    ftp.disconnect();
                }
                catch (IOException ioe) {
                    log.error((Object)ioe.getMessage(), (Throwable)ioe);
                }
            }
        }
        return result;
    }
}

