/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.ftpclient;

import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.memtree.MemTreeBuilder;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.ftpclient.FTPClientModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class GetDirListFunction
extends BasicFunction {
    private static final Logger log = Logger.getLogger(GetDirListFunction.class);
    private static final FunctionParameterSequenceType CONNECTION_HANDLE_PARAM = new FunctionParameterSequenceType("connection-handle", 37, 2, "The connection handle");
    private static final FunctionParameterSequenceType REMOTE_DIRECTORY_PARAM = new FunctionParameterSequenceType("remote-directory", 22, 2, "The remote directory");
    public static final FunctionSignature signature = new FunctionSignature(new QName("list", "http://exist-db.org/xquery/ftpclient", "ftpclient"), "Get file list from remote FTP server.", new SequenceType[]{CONNECTION_HANDLE_PARAM, REMOTE_DIRECTORY_PARAM}, (SequenceType)new FunctionReturnSequenceType(6, 3, "Response from server in XML"));

    public GetDirListFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result = Sequence.EMPTY_SEQUENCE;
        long connectionUID = ((IntegerValue)args[0].itemAt(0)).getLong();
        FTPClient ftp = FTPClientModule.retrieveConnection(this.context, connectionUID);
        if (ftp != null) {
            String remoteDirectory = args[1].getStringValue();
            result = this.list(ftp, remoteDirectory);
        }
        return result;
    }

    private Sequence list(FTPClient ftp, String remoteDirectory) {
        Sequence result = Sequence.EMPTY_SEQUENCE;
        try {
            ftp.changeWorkingDirectory(remoteDirectory);
            FTPFile[] ftpFiles = ftp.listFiles();
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            builder.startDocument();
            builder.startElement(new QName("list", "http://exist-db.org/xquery/ftpclient"), null);
            for (FTPFile ftpFile : ftpFiles) {
                if (ftpFile.getType() == 0) {
                    builder.startElement(new QName("file", "http://exist-db.org/xquery/ftpclient"), null);
                } else if (ftpFile.getType() == 1) {
                    builder.startElement(new QName("directory", "http://exist-db.org/xquery/ftpclient"), null);
                }
                builder.characters((CharSequence)ftpFile.getName());
                builder.endElement();
            }
            builder.endElement();
            builder.endDocument();
            result = builder.getDocument();
        }
        catch (IOException ioe) {
            log.error((Object)ioe.getMessage(), (Throwable)ioe);
        }
        return result;
    }
}

