/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.ftpclient;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.ftpclient.FTPClientModule;
import org.exist.xquery.value.Base64BinaryValueType;
import org.exist.xquery.value.BinaryValueFromInputStream;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.BinaryValueType;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class GetFileFunction
extends BasicFunction {
    private static final FunctionParameterSequenceType CONNECTION_HANDLE_PARAM = new FunctionParameterSequenceType("connection-handle", 37, 2, "The connection handle");
    private static final FunctionParameterSequenceType REMOTE_DIRECTORY_PARAM = new FunctionParameterSequenceType("remote-directory", 22, 2, "The remote directory");
    private static final FunctionParameterSequenceType FILE_NAME_PARAM = new FunctionParameterSequenceType("file-name", 22, 2, "File name");
    private static final Logger log = Logger.getLogger(GetFileFunction.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-binary-file", "http://exist-db.org/xquery/ftpclient", "ftpclient"), "Get binary file from the FTP Server.", new SequenceType[]{CONNECTION_HANDLE_PARAM, REMOTE_DIRECTORY_PARAM, FILE_NAME_PARAM}, (SequenceType)new FunctionReturnSequenceType(26, 3, "File retrieved from the server."));

    public GetFileFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result = Sequence.EMPTY_SEQUENCE;
        long connectionUID = ((IntegerValue)args[0].itemAt(0)).getLong();
        FTPClient ftp = FTPClientModule.retrieveConnection(this.context, connectionUID);
        if (ftp != null) {
            String remoteDirectory = args[1].getStringValue();
            String fileName = args[2].getStringValue();
            result = this.getBinaryFile(ftp, remoteDirectory, fileName);
        }
        return result;
    }

    private Sequence getBinaryFile(FTPClient ftp, String remoteDirectory, String fileName) throws XPathException {
        Sequence result = Sequence.EMPTY_SEQUENCE;
        try {
            ftp.changeWorkingDirectory(remoteDirectory);
            ftp.setFileType(2);
            result = BinaryValueFromInputStream.getInstance((BinaryValueManager)this.context, (BinaryValueType)new Base64BinaryValueType(), (InputStream)ftp.retrieveFileStream(fileName));
        }
        catch (IOException ioe) {
            log.error((Object)ioe.getMessage(), (Throwable)ioe);
        }
        return result;
    }
}

