/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.ftpclient;

import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.ftpclient.FTPClientModule;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class SendFileFunction
extends BasicFunction {
    private static final FunctionParameterSequenceType CONNECTION_HANDLE_PARAM = new FunctionParameterSequenceType("connection-handle", 37, 2, "The connection handle");
    private static final FunctionParameterSequenceType REMOTE_DIRECTORY_PARAM = new FunctionParameterSequenceType("remote-directory", 22, 2, "The remote directory");
    private static final FunctionParameterSequenceType FILE_NAME_PARAM = new FunctionParameterSequenceType("file-name", 22, 2, "File name");
    private static final FunctionParameterSequenceType DATA_PARAM = new FunctionParameterSequenceType("data", 26, 2, "The binary file data to send");
    private static final Logger log = Logger.getLogger(SendFileFunction.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("send-binary-file", "http://exist-db.org/xquery/ftpclient", "ftpclient"), "Send binary files via FTP.", new SequenceType[]{CONNECTION_HANDLE_PARAM, REMOTE_DIRECTORY_PARAM, FILE_NAME_PARAM, DATA_PARAM}, (SequenceType)new FunctionReturnSequenceType(23, 2, "true or false indicating the success of the file send"));

    public SendFileFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result = Sequence.EMPTY_SEQUENCE;
        long connectionUID = ((IntegerValue)args[0].itemAt(0)).getLong();
        FTPClient ftp = FTPClientModule.retrieveConnection(this.context, connectionUID);
        if (ftp != null) {
            String remoteDirectory = args[1].getStringValue();
            String fileName = args[2].getStringValue();
            BinaryValue data = (BinaryValue)args[3].itemAt(0);
            result = this.sendBinaryFile(ftp, remoteDirectory, fileName, data);
        }
        return result;
    }

    private Sequence sendBinaryFile(FTPClient ftp, String remoteDirectory, String fileName, BinaryValue data) {
        boolean result = false;
        try {
            ftp.changeWorkingDirectory(remoteDirectory);
            ftp.setFileType(2);
            result = ftp.storeFile(fileName, data.getInputStream());
        }
        catch (IOException ioe) {
            log.error((Object)ioe.getMessage(), (Throwable)ioe);
            result = false;
        }
        return BooleanValue.valueOf((boolean)result);
    }
}

