/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.httpclient;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.memtree.DocumentBuilderReceiver;
import org.exist.memtree.MemTreeBuilder;
import org.exist.memtree.NodeImpl;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.ModuleUtils;
import org.exist.xquery.value.Base64BinaryValueType;
import org.exist.xquery.value.BinaryValueFromInputStream;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.BinaryValueType;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class BaseHTTPClientFunction
extends BasicFunction {
    protected static final Logger logger = Logger.getLogger(BaseHTTPClientFunction.class);
    protected static final FunctionParameterSequenceType URI_PARAM = new FunctionParameterSequenceType("url", 25, 2, "The URL to process");
    protected static final FunctionParameterSequenceType PUT_CONTENT_PARAM = new FunctionParameterSequenceType("content", 11, 2, "The XML PUT payload/content. If it is an XML Node it will be serialized. If it is a binary stream it pass as it, any other type will be atomized into a string.");
    protected static final FunctionParameterSequenceType POST_CONTENT_PARAM = new FunctionParameterSequenceType("content", 11, 2, "The XML POST payload/content. If it is an XML Node it will be serialized, any other type will be atomized into a string.");
    protected static final FunctionParameterSequenceType POST_FORM_PARAM = new FunctionParameterSequenceType("content", 1, 2, "The form data in the format <httpclient:fields><httpclient:field name=\"\" value=\"\" type=\"string|file\"/>...</httpclient:fields>.  If the field values will be suitably URLEncoded and sent with the mime type application/x-www-form-urlencoded.");
    protected static final FunctionParameterSequenceType PERSIST_PARAM = new FunctionParameterSequenceType("persist", 23, 2, "Indicates if the HTTP state (eg. cookies, credentials, etc.) should persist for the life of this xquery");
    protected static final FunctionParameterSequenceType REQUEST_HEADER_PARAM = new FunctionParameterSequenceType("request-headers", 1, 3, "Any HTTP Request Headers to set in the form  <headers><header name=\"\" value=\"\"/></headers>");
    protected static final FunctionParameterSequenceType OPTIONS_PARAM = new FunctionParameterSequenceType("parser-options", 1, 3, "Feature and Property options to be passed to the HTML/XML parser in the form <options><feature name=\"\" value=\"{true|false}\"/><property name=\"\" value=\"\"/></options>");
    protected static final FunctionParameterSequenceType INDENTATION_PARAM = new FunctionParameterSequenceType("indentation", 31, 2, "Indentation level.  If this parameter is added, then the XML being put will be serailazed with indentation and the number is the number of characters for each level of indentation.  If this parameter is not include, then the XML is serialized to one line of text.");
    protected static final FunctionReturnSequenceType XML_BODY_RETURN = new FunctionReturnSequenceType(11, 2, "the XML body content");
    static final String NAMESPACE_URI = "http://exist-db.org/xquery/httpclient";
    static final String PREFIX = "httpclient";
    static final String HTTP_MODULE_PERSISTENT_STATE = "_eXist_httpclient_module_persistent_state";
    static final String HTTP_EXCEPTION_STATUS_CODE = "500";

    public BaseHTTPClientFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    protected void setHeaders(HttpMethod method, Node headers) throws XPathException {
        if (headers.getNodeType() == 1 && headers.getLocalName().equals("headers")) {
            NodeList headerList = headers.getChildNodes();
            for (int i = 0; i < headerList.getLength(); ++i) {
                Node header = headerList.item(i);
                if (header.getNodeType() != 1 || !header.getLocalName().equals("header")) continue;
                String name = ((Element)header).getAttribute("name");
                String value = ((Element)header).getAttribute("value");
                if (name == null || value == null) {
                    throw new XPathException((Expression)this, "Name or value attribute missing for request header parameter");
                }
                method.addRequestHeader(new Header(name, value));
            }
        }
    }

    protected Sequence doRequest(XQueryContext context, HttpMethod method, boolean persistState, Map<String, Boolean> parserFeatures, Map<String, String> parserProperties) throws IOException, XPathException {
        int statusCode = 0;
        Sequence encodedResponse = null;
        HttpClient http = new HttpClient();
        try {
            String proxyHost;
            String configFile;
            HttpState state;
            if (persistState && (state = (HttpState)context.getXQueryContextVar(HTTP_MODULE_PERSISTENT_STATE)) != null) {
                http.setState(state);
            }
            if ((configFile = System.getProperty("http.configfile")) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("http.configfile='" + configFile + "'"));
                }
                Properties props = new Properties();
                try {
                    File propsFile = new File(configFile);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Loading proxy settings from " + propsFile.getAbsolutePath()));
                    }
                    props.load(new FileInputStream(propsFile));
                }
                catch (IOException ex) {
                    logger.error((Object)("Failed to read proxy configuration from '" + configFile + "'"));
                }
                String proxyHost2 = props.getProperty("proxy.host");
                int proxyPort = Integer.valueOf(props.getProperty("proxy.port", "8080"));
                String proxyUser = props.getProperty("proxy.user");
                String proxyPassword = props.getProperty("proxy.password");
                String proxyDomain = props.getProperty("proxy.ntlm.domain");
                if ("NONE".equalsIgnoreCase(proxyDomain)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Forcing removal NTLM");
                    }
                    proxyDomain = null;
                }
                AuthScope authScope = new AuthScope(proxyHost2, proxyPort);
                UsernamePasswordCredentials credentials = null;
                if (proxyDomain == null) {
                    credentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Using NTLM authentication for '" + proxyDomain + "'"));
                    }
                    credentials = new NTCredentials(proxyUser, proxyPassword, proxyHost2, proxyDomain);
                }
                HttpState state2 = http.getState();
                http.getHostConfiguration().setProxy(proxyHost2, proxyPort);
                state2.setProxyCredentials(authScope, (Credentials)credentials);
                if (logger.isDebugEnabled()) {
                    logger.info((Object)("Set proxy: " + proxyUser + "@" + proxyHost2 + ":" + proxyPort + (proxyDomain == null ? "" : " (NTLM:'" + proxyDomain + "')")));
                }
            }
            if ((proxyHost = System.getProperty("http.proxyHost")) != null) {
                ProxyHost proxy = new ProxyHost(proxyHost, Integer.parseInt(System.getProperty("http.proxyPort")));
                http.getHostConfiguration().setProxyHost(proxy);
            }
            statusCode = http.executeMethod(method);
            encodedResponse = this.encodeResponseAsXML(context, method, statusCode, parserFeatures, parserProperties);
            if (persistState) {
                context.setXQueryContextVar(HTTP_MODULE_PERSISTENT_STATE, (Object)http.getState());
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            encodedResponse = this.encodeErrorResponse(context, e.getMessage());
        }
        return encodedResponse;
    }

    private Sequence encodeResponseAsXML(XQueryContext context, HttpMethod method, int statusCode, Map<String, Boolean> parserFeatures, Map<String, String> parserProperties) throws XPathException, IOException {
        NodeValue xmlResponse = null;
        MemTreeBuilder builder = context.getDocumentBuilder();
        builder.startDocument();
        builder.startElement(new QName("response", NAMESPACE_URI, PREFIX), null);
        builder.addAttribute(new QName("statusCode", null, null), String.valueOf(statusCode));
        builder.startElement(new QName("headers", NAMESPACE_URI, PREFIX), null);
        Header[] headers = method.getResponseHeaders();
        for (int i = 0; i < headers.length; ++i) {
            builder.startElement(new QName("header", NAMESPACE_URI, PREFIX), null);
            builder.addAttribute(new QName("name", null, null), headers[i].getName());
            builder.addAttribute(new QName("value", null, null), headers[i].getValue());
            builder.endElement();
        }
        builder.endElement();
        if (!(method instanceof HeadMethod) && !(method instanceof OptionsMethod)) {
            builder.startElement(new QName("body", NAMESPACE_URI, PREFIX), null);
            this.insertResponseBody(context, method, builder, parserFeatures, parserProperties);
            builder.endElement();
        }
        builder.endElement();
        xmlResponse = (NodeValue)builder.getDocument().getDocumentElement();
        return xmlResponse;
    }

    private Sequence encodeErrorResponse(XQueryContext context, String message) throws IOException, XPathException {
        NodeValue xmlResponse = null;
        MemTreeBuilder builder = context.getDocumentBuilder();
        builder.startDocument();
        builder.startElement(new QName("response", NAMESPACE_URI, PREFIX), null);
        builder.addAttribute(new QName("statusCode", null, null), HTTP_EXCEPTION_STATUS_CODE);
        builder.startElement(new QName("body", NAMESPACE_URI, PREFIX), null);
        builder.addAttribute(new QName("type", null, null), "text");
        builder.addAttribute(new QName("encoding", null, null), "URLEncoded");
        if (message != null) {
            builder.characters((CharSequence)URLEncoder.encode(message, "UTF-8"));
        }
        builder.endElement();
        builder.endElement();
        xmlResponse = (NodeValue)builder.getDocument().getDocumentElement();
        return xmlResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertResponseBody(XQueryContext context, HttpMethod method, MemTreeBuilder builder, Map<String, Boolean> parserFeatures, Map<String, String> parserProperties) throws IOException, XPathException {
        boolean parsed = false;
        NodeImpl responseNode = null;
        InputStream bodyAsStream = method.getResponseBodyAsStream();
        if (bodyAsStream != null) {
            int len;
            long contentLength = ((HttpMethodBase)method).getResponseContentLength();
            if (contentLength > Integer.MAX_VALUE) {
                throw new XPathException((Expression)this, "HTTPClient response too large to be buffered: " + contentLength + " bytes");
            }
            ByteArrayOutputStream outstream = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((len = bodyAsStream.read(buffer)) > 0) {
                outstream.write(buffer, 0, len);
            }
            outstream.close();
            byte[] body = outstream.toByteArray();
            Header responseContentType = method.getResponseHeader("Content-Type");
            MimeType responseMimeType = this.getResponseMimeType(responseContentType);
            if (responseContentType != null) {
                builder.addAttribute(new QName("mimetype", null, null), responseContentType.getValue());
            }
            try {
                responseNode = (NodeImpl)ModuleUtils.streamToXML((XQueryContext)context, (InputStream)new ByteArrayInputStream(body));
                builder.addAttribute(new QName("type", null, null), "xml");
                responseNode.copyTo(null, new DocumentBuilderReceiver(builder));
            }
            catch (SAXException se) {
                String msg = "Request for URI '" + method.getURI().toString() + "' Could not parse http response content as XML (will try html, text or fallback to binary): " + se.getMessage();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)msg, (Throwable)se);
                } else {
                    logger.info((Object)msg);
                }
            }
            catch (IOException ioe) {
                String msg = "Request for URI '" + method.getURI().toString() + "' Could not read http response content: " + ioe.getMessage();
                logger.error((Object)msg, (Throwable)ioe);
                throw new XPathException(msg, (Throwable)ioe);
            }
            if (responseNode == null && responseMimeType.getName().equals(MimeType.HTML_TYPE.getName())) {
                try {
                    responseNode = (NodeImpl)ModuleUtils.htmlToXHtml((XQueryContext)context, (String)method.getURI().toString(), (InputSource)new InputSource(new ByteArrayInputStream(body)), parserFeatures, parserProperties).getDocumentElement();
                    builder.addAttribute(new QName("type", null, null), "xhtml");
                    responseNode.copyTo(null, new DocumentBuilderReceiver(builder));
                }
                catch (URIException ue) {
                    throw new XPathException((Expression)this, ue.getMessage(), (Throwable)ue);
                }
                catch (SAXException se) {
                    logger.debug((Object)("Could not parse http response content from HTML to XML: " + se.getMessage()), (Throwable)se);
                }
            }
            if (responseNode == null) {
                if (responseMimeType.getName().startsWith("text/")) {
                    builder.addAttribute(new QName("type", null, null), "text");
                    builder.addAttribute(new QName("encoding", null, null), "URLEncoded");
                    builder.characters((CharSequence)URLEncoder.encode(EncodingUtil.getString((byte[])body, (String)((HttpMethodBase)method).getResponseCharSet()), "UTF-8"));
                } else {
                    builder.addAttribute(new QName("type", null, null), "binary");
                    builder.addAttribute(new QName("encoding", null, null), "Base64Encoded");
                    if (body != null) {
                        BinaryValueFromInputStream binary = null;
                        try {
                            binary = BinaryValueFromInputStream.getInstance((BinaryValueManager)context, (BinaryValueType)new Base64BinaryValueType(), (InputStream)new ByteArrayInputStream(body));
                            builder.characters((CharSequence)binary.getStringValue());
                        }
                        finally {
                            if (binary != null) {
                                binary.destroy(context, null);
                            }
                        }
                    }
                }
            }
        }
    }

    protected MimeType getResponseMimeType(Header responseHeaderContentType) {
        MimeType returnMimeType = MimeType.BINARY_TYPE;
        if (responseHeaderContentType != null && responseHeaderContentType.getName().equals("Content-Type")) {
            String responseContentType = responseHeaderContentType.getValue();
            int contentTypeEnd = responseContentType.indexOf(";");
            if (contentTypeEnd == -1) {
                contentTypeEnd = responseContentType.length();
            }
            String responseMimeType = responseContentType.substring(0, contentTypeEnd);
            MimeTable mimeTable = MimeTable.getInstance();
            MimeType mimeType = mimeTable.getContentType(responseMimeType);
            if (mimeType != null) {
                returnMimeType = mimeType;
            }
        }
        return returnMimeType;
    }

    protected FeaturesAndProperties getParserFeaturesAndProperties(Node options) throws XPathException {
        HashMap<String, Boolean> features = new HashMap<String, Boolean>();
        HashMap<String, String> properties = new HashMap<String, String>();
        if (options.getNodeType() == 1 && options.getLocalName().equals("options")) {
            NodeList optionList = options.getChildNodes();
            for (int i = 0; i < optionList.getLength(); ++i) {
                Node option = optionList.item(i);
                if (option.getNodeType() != 1) continue;
                String name = ((Element)option).getAttribute("name");
                String value = ((Element)option).getAttribute("value");
                if (name == null || value == null) {
                    throw new XPathException((Expression)this, "Name or value attribute missing for parser feature/property");
                }
                if (option.getLocalName().equals("feature")) {
                    if (value.matches("(true|false)")) {
                        features.put(name, Boolean.parseBoolean(value));
                        continue;
                    }
                    throw new XPathException((Expression)this, "Feature value must be true or false");
                }
                if (!option.getLocalName().equals("property")) continue;
                properties.put(name, value);
            }
        }
        return new FeaturesAndProperties(features, properties);
    }

    protected class FeaturesAndProperties {
        private Map<String, Boolean> features = new HashMap<String, Boolean>();
        private Map<String, String> properties = new HashMap<String, String>();

        public FeaturesAndProperties(Map<String, Boolean> features, Map<String, String> properties) {
            this.features = features;
            this.properties = properties;
        }

        public Map<String, Boolean> getFeatures() {
            return this.features;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }
    }
}

