/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.httpclient;

import org.apache.commons.httpclient.HttpState;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.httpclient.BaseHTTPClientFunction;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class ClearFunction
extends BaseHTTPClientFunction {
    protected static final Logger logger = Logger.getLogger(ClearFunction.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("clear-all", "http://exist-db.org/xquery/httpclient", "httpclient"), "Clears all persistent state (eg. cookies, crednetials, etc.) stored in the current session on the client.", null, new SequenceType(11, 1)), new FunctionSignature(new QName("clear-persistent-cookies", "http://exist-db.org/xquery/httpclient", "httpclient"), "Clears any persistent cookies stored in the current session on the client.", null, new SequenceType(11, 1)), new FunctionSignature(new QName("clear-persistent-credentials", "http://exist-db.org/xquery/httpclient", "httpclient"), "Clears any persistent credentials stored in the current session on the client.", null, new SequenceType(11, 1)), new FunctionSignature(new QName("clear-persistent-proxy-credentials", "http://exist-db.org/xquery/httpclient", "httpclient"), "Clears any persistent proxy credentials stored in the current session on the client.", null, new SequenceType(11, 1))};

    public ClearFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (this.isCalledAs("clear-all")) {
            this.context.setXQueryContextVar("_eXist_httpclient_module_persistent_state", null);
        } else {
            HttpState state = (HttpState)this.context.getXQueryContextVar("_eXist_httpclient_module_persistent_state");
            if (state != null) {
                if (this.isCalledAs("clear-persistent-cookies")) {
                    state.clearCookies();
                } else if (this.isCalledAs("clear-persistent-credentials")) {
                    state.clearCredentials();
                } else if (this.isCalledAs("clear-persistent-proxy-credentials")) {
                    state.clearProxyCredentials();
                }
            }
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

