/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.httpclient;

import java.io.IOException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.httpclient.BaseHTTPClientFunction;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class OPTIONSFunction
extends BaseHTTPClientFunction {
    protected static final Logger logger = Logger.getLogger(OPTIONSFunction.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("options", "http://exist-db.org/xquery/httpclient", "httpclient"), "Performs a HTTP OPTIONS request. This method returns the HTTP response encoded as an XML fragment, that looks as follows: <httpclient:response  xmlns:httpclient=\"http://exist-db.org/xquery/httpclient\" statusCode=\"200\"><httpclient:headers><httpclient:header name=\"name\" value=\"value\"/>...</httpclient:headers></httpclient:response>", new SequenceType[]{URI_PARAM, PERSIST_PARAM, REQUEST_HEADER_PARAM}, (SequenceType)XML_BODY_RETURN);

    public OPTIONSFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence response = null;
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String url = args[0].itemAt(0).getStringValue();
        boolean persistState = args[1].effectiveBooleanValue();
        OptionsMethod options = new OptionsMethod(url);
        if (!args[2].isEmpty()) {
            this.setHeaders((HttpMethod)options, ((NodeValue)args[2].itemAt(0)).getNode());
        }
        try {
            response = this.doRequest(this.context, (HttpMethod)options, persistState, null, null);
        }
        catch (IOException ioe) {
            throw new XPathException((Expression)this, ioe.getMessage(), (Throwable)ioe);
        }
        finally {
            options.releaseConnection();
        }
        return response;
    }
}

