/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Base64BinaryValueType;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.BinaryValueFromInputStream;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.BinaryValueType;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class CropFunction
extends BasicFunction {
    private static final Logger logger = Logger.getLogger(CropFunction.class);
    private static final int MAXHEIGHT = 100;
    private static final int MAXWIDTH = 100;
    public static final FunctionSignature signature = new FunctionSignature(new QName("crop", "http://exist-db.org/xquery/image", "image"), "Crop the image $image to a specified dimension.  If no dimensions are specified, then the default values are 'y1 = 0', 'x1 = 0', 'x2 = 100' and 'y2 = 100'.", new SequenceType[]{new FunctionParameterSequenceType("image", 26, 2, "The image data"), new FunctionParameterSequenceType("dimension", 31, 7, "The maximum dimension of the cropd image. expressed in pixels (x1, y1, x2, y2).  If empty, then the default values are are 'y1 = 0', 'x1 = 0', 'x2 = 100' and 'y2 = 100'."), new FunctionParameterSequenceType("mimeType", 22, 2, "The mime-type of the image")}, (SequenceType)new FunctionReturnSequenceType(26, 3, "the cropd image or an empty sequence if $image is invalid"));

    public CropFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty() || args[2].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        int x1 = 0;
        int y1 = 0;
        int x2 = 100;
        int y2 = 100;
        if (!args[1].isEmpty()) {
            x1 = ((IntegerValue)args[1].itemAt(0)).getInt();
            if (args[1].hasMany()) {
                y1 = ((IntegerValue)args[1].itemAt(1)).getInt();
                x2 = ((IntegerValue)args[1].itemAt(2)).getInt();
                y2 = ((IntegerValue)args[1].itemAt(3)).getInt();
            }
        }
        String mimeType = args[2].itemAt(0).getStringValue();
        String formatName = mimeType.substring(mimeType.indexOf("/") + 1);
        BufferedImage image = null;
        BufferedImage bImage = null;
        try {
            image = ImageIO.read(((BinaryValue)args[0].itemAt(0)).getInputStream());
            if (image == null) {
                logger.error((Object)"Unable to read image data!");
                return Sequence.EMPTY_SEQUENCE;
            }
            Image cropImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(((Image)image).getSource(), new CropImageFilter(x1, y1, x2, y2)));
            if (cropImage instanceof BufferedImage) {
                bImage = (BufferedImage)cropImage;
            } else {
                bImage = new BufferedImage(cropImage.getHeight(null), cropImage.getWidth(null), 1);
                Graphics2D g = bImage.createGraphics();
                g.drawImage(cropImage, 0, 0, null);
                g.dispose();
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bImage, formatName, (OutputStream)os);
            return BinaryValueFromInputStream.getInstance((BinaryValueManager)this.context, (BinaryValueType)new Base64BinaryValueType(), (InputStream)new ByteArrayInputStream(os.toByteArray()));
        }
        catch (Exception e) {
            throw new XPathException((Expression)this, e.getMessage());
        }
    }
}

