/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.image;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class GetWidthFunction
extends BasicFunction {
    private static final Logger logger = Logger.getLogger(GetWidthFunction.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-width", "http://exist-db.org/xquery/image", "image"), "Gets the width of the image passed in, returning an integer of the images width in pixels or an empty sequence if the image is invalid.", new SequenceType[]{new FunctionParameterSequenceType("image", 26, 2, "The image data")}, (SequenceType)new FunctionReturnSequenceType(31, 3, "the width in pixels"));

    public GetWidthFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        BufferedImage image = null;
        try {
            BinaryValue imageData = (BinaryValue)args[0].itemAt(0);
            image = ImageIO.read(imageData.getInputStream());
        }
        catch (IOException ioe) {
            logger.error((Object)"Unable to read image data!", (Throwable)ioe);
            return Sequence.EMPTY_SEQUENCE;
        }
        if (image == null) {
            logger.error((Object)"Unable to read image data!");
            return Sequence.EMPTY_SEQUENCE;
        }
        int iWidth = ((Image)image).getWidth(null);
        if (iWidth == -1) {
            logger.error((Object)"Unable to read image data!");
            return Sequence.EMPTY_SEQUENCE;
        }
        return new IntegerValue((long)iWidth);
    }
}

