/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.jfreechart;

import java.awt.Color;
import org.apache.log4j.Logger;
import org.exist.xquery.XPathException;
import org.exist.xquery.modules.jfreechart.Colour;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.util.TableOrder;
import org.w3c.dom.Node;

public class Configuration {
    private static final Logger logger = Logger.getLogger(Configuration.class);
    private int imageHeight = 300;
    private int imageWidth = 400;
    private String title;
    private String imageType = "png";
    private String categoryAxisLabel;
    private String domainAxisLabel;
    private String rangeAxisLabel;
    private String timeAxisLabel;
    private String valueAxisLabel;
    private String pieSectionLabel;
    private String pieSectionNumberFormat = "0";
    private String pieSectionPercentFormat = "0.0%";
    private String categoryItemLabelGeneratorClass;
    private String categoryItemLabelGeneratorParameter = "{2}";
    private String categoryItemLabelGeneratorNumberFormat = "0";
    private TableOrder order = TableOrder.BY_COLUMN;
    private PlotOrientation orientation = PlotOrientation.HORIZONTAL;
    private Color titleColor;
    private Color chartBackgroundColor;
    private Color plotBackgroundColor;
    private Color categoryAxisColor;
    private Color timeAxisColor;
    private Color valueAxisColor;
    private String seriesColors;
    private String sectionColors;
    private String sectionColorsDelimiter = ",";
    private Double rangeLowerBound;
    private Double rangeUpperBound;
    private boolean generateLegend = false;
    private boolean generateTooltips = false;
    private boolean generateUrls = false;

    public String getImageType() {
        return this.imageType;
    }

    public String getTimeAxisLabel() {
        return this.timeAxisLabel;
    }

    public Color getTimeAxisColor() {
        return this.timeAxisColor;
    }

    public String getCategoryAxisLabel() {
        return this.categoryAxisLabel;
    }

    public Color getCategoryAxisColor() {
        return this.categoryAxisColor;
    }

    public boolean isGenerateLegend() {
        return this.generateLegend;
    }

    public boolean isGenerateTooltips() {
        return this.generateTooltips;
    }

    public boolean isGenerateUrls() {
        return this.generateUrls;
    }

    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public TableOrder getOrder() {
        return this.order;
    }

    public String getTitle() {
        return this.title;
    }

    public String getValueAxisLabel() {
        return this.valueAxisLabel;
    }

    public Color getValueAxisColor() {
        return this.valueAxisColor;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public String getDomainAxisLabel() {
        return this.domainAxisLabel;
    }

    public String getRangeAxisLabel() {
        return this.rangeAxisLabel;
    }

    public String getPieSectionLabel() {
        return this.pieSectionLabel;
    }

    public String getPieSectionNumberFormat() {
        return this.pieSectionNumberFormat;
    }

    public String getPieSectionPercentFormat() {
        return this.pieSectionPercentFormat;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public Color getChartBackgroundColor() {
        return this.chartBackgroundColor;
    }

    public Color getPlotBackgroundColor() {
        return this.plotBackgroundColor;
    }

    public Double getRangeLowerBound() {
        return this.rangeLowerBound;
    }

    public Double getRangeUpperBound() {
        return this.rangeUpperBound;
    }

    public String getCategoryItemLabelGeneratorClass() {
        return this.categoryItemLabelGeneratorClass;
    }

    public String getCategoryItemLabelGeneratorParameter() {
        return this.categoryItemLabelGeneratorParameter;
    }

    public String getCategoryItemLabelGeneratorNumberFormat() {
        return this.categoryItemLabelGeneratorNumberFormat;
    }

    public String getSeriesColors() {
        return this.seriesColors;
    }

    public String getSectionColors() {
        return this.sectionColors;
    }

    public String getSectionColorsDelimiter() {
        return this.sectionColorsDelimiter;
    }

    public void parse(Node configuration) throws XPathException {
        if (configuration.getNodeType() == 1 && configuration.getLocalName().equals("configuration")) {
            for (Node child = configuration.getFirstChild(); child != null; child = child.getNextSibling()) {
                Object value;
                if (child.getNodeType() != 1 || !child.hasChildNodes()) continue;
                if (child.getLocalName().equals("title")) {
                    value = this.getValue(child);
                    if (value == null) {
                        throw new XPathException("Value for 'title' cannot be parsed");
                    }
                    this.title = value;
                    continue;
                }
                if (child.getLocalName().equals("categoryAxisLabel")) {
                    value = this.getValue(child);
                    if (value == null) {
                        throw new XPathException("Value for 'categoryAxisLabel' cannot be parsed");
                    }
                    this.categoryAxisLabel = value;
                    continue;
                }
                if (child.getLocalName().equals("categoryAxisColor")) {
                    value = Colour.getColor(this.getValue(child));
                    if (value == null) {
                        throw new XPathException("Value for 'categoryAxisColor' cannot be parsed");
                    }
                    this.categoryAxisColor = value;
                    continue;
                }
                if (child.getLocalName().equals("valueAxisLabel")) {
                    value = this.getValue(child);
                    if (value == null) {
                        throw new XPathException("Value for 'valueAxisLabel' cannot be parsed");
                    }
                    this.valueAxisLabel = value;
                    continue;
                }
                if (child.getLocalName().equals("valueAxisColor")) {
                    value = Colour.getColor(this.getValue(child));
                    if (value == null) {
                        throw new XPathException("Value for 'valueAxisColor' cannot be parsed");
                    }
                    this.valueAxisColor = value;
                    continue;
                }
                if (child.getLocalName().equals("timeAxisLabel")) {
                    value = this.getValue(child);
                    if (value == null) {
                        throw new XPathException("Value for 'timeAxisLabel' cannot be parsed");
                    }
                    this.timeAxisLabel = value;
                    continue;
                }
                if (child.getLocalName().equals("timeAxisColor")) {
                    value = Colour.getColor(this.getValue(child));
                    if (value == null) {
                        throw new XPathException("Value for 'timeAxisColor' cannot be parsed");
                    }
                    this.timeAxisColor = value;
                    continue;
                }
                if (child.getLocalName().equals("domainAxisLabel")) {
                    value = this.getValue(child);
                    if (value == null) {
                        throw new XPathException("Value for 'domainAxisLabel' cannot be parsed");
                    }
                    this.domainAxisLabel = value;
                    continue;
                }
                if (child.getLocalName().equals("rangeAxisLabel")) {
                    value = this.getValue(child);
                    if (value == null) {
                        throw new XPathException("Value for 'rangeAxisLabel' cannot be parsed");
                    }
                    this.rangeAxisLabel = value;
                    continue;
                }
                if (child.getLocalName().equals("pieSectionLabel")) {
                    value = this.getValue(child);
                    if (value == null) {
                        throw new XPathException("Value for 'pieSectionLabel' cannot be parsed");
                    }
                    this.pieSectionLabel = value;
                    continue;
                }
                if (child.getLocalName().equals("pieSectionNumberFormat")) {
                    value = this.getValue(child);
                    if (value == null) {
                        throw new XPathException("Value for 'pieSectionNumberFormat' cannot be parsed");
                    }
                    this.pieSectionNumberFormat = value;
                    continue;
                }
                if (child.getLocalName().equals("pieSectionPercentFormat")) {
                    value = this.getValue(child);
                    if (value == null) {
                        throw new XPathException("Value for 'pieSectionPercentFormat' cannot be parsed");
                    }
                    this.pieSectionPercentFormat = value;
                    continue;
                }
                if (child.getLocalName().equals("orientation")) {
                    value = this.getValue(child);
                    if (value == null) {
                        throw new XPathException("Value for 'orientation' cannot be parsed");
                    }
                    if ("HORIZONTAL".equalsIgnoreCase((String)value)) {
                        this.orientation = PlotOrientation.HORIZONTAL;
                        continue;
                    }
                    if ("VERTICAL".equalsIgnoreCase((String)value)) {
                        this.orientation = PlotOrientation.VERTICAL;
                        continue;
                    }
                    throw new XPathException("Wrong value for 'orientation'");
                }
                if (child.getLocalName().equals("tableOrder")) {
                    value = this.getValue(child);
                    if (value == null) {
                        throw new XPathException("Value for 'tableOrder' cannot be parsed");
                    }
                    if ("COLUMN".equalsIgnoreCase((String)value)) {
                        this.order = TableOrder.BY_COLUMN;
                        continue;
                    }
                    if ("ROW".equalsIgnoreCase((String)value)) {
                        this.order = TableOrder.BY_ROW;
                        continue;
                    }
                    throw new XPathException("Wrong value for 'tableOrder'");
                }
                if (child.getLocalName().equals("legend")) {
                    value = this.parseBoolean(this.getValue(child));
                    if (value == null) {
                        throw new XPathException("Value for 'legend' cannot be parsed");
                    }
                    this.generateLegend = (Boolean)value;
                    continue;
                }
                if (child.getLocalName().equals("tooltips")) {
                    value = this.parseBoolean(this.getValue(child));
                    if (value == null) {
                        throw new XPathException("Value for 'tooltips' cannot be parsed");
                    }
                    this.generateTooltips = (Boolean)value;
                    continue;
                }
                if (child.getLocalName().equals("urls")) {
                    value = this.parseBoolean(this.getValue(child));
                    if (value == null) {
                        throw new XPathException("Value for 'urls' cannot be parsed");
                    }
                    this.generateUrls = (Boolean)value;
                    continue;
                }
                if (child.getLocalName().equals("width")) {
                    value = this.parseInteger(this.getValue(child));
                    if (value == null) {
                        throw new XPathException("Value for 'width' cannot be parsed");
                    }
                    this.imageWidth = (Integer)value;
                    continue;
                }
                if (child.getLocalName().equals("height")) {
                    value = this.parseInteger(this.getValue(child));
                    if (value == null) {
                        throw new XPathException("Value for 'height' cannot be parsed");
                    }
                    this.imageHeight = (Integer)value;
                    continue;
                }
                if (child.getLocalName().equals("titleColor")) {
                    value = Colour.getColor(this.getValue(child));
                    if (value == null) {
                        throw new XPathException("Value for 'titleColor' cannot be parsed");
                    }
                    this.titleColor = value;
                    continue;
                }
                if (child.getLocalName().equals("chartBackgroundColor")) {
                    value = Colour.getColor(this.getValue(child));
                    if (value == null) {
                        throw new XPathException("Value for 'chartBackgroundColor' cannot be parsed");
                    }
                    this.chartBackgroundColor = value;
                    continue;
                }
                if (child.getLocalName().equals("plotBackgroundColor")) {
                    value = Colour.getColor(this.getValue(child));
                    if (value == null) {
                        throw new XPathException("Value for 'plotBackgroundColor' cannot be parsed");
                    }
                    this.plotBackgroundColor = value;
                    continue;
                }
                if (child.getLocalName().equals("seriesColors")) {
                    value = this.getValue(child);
                    if (value == null) {
                        throw new XPathException("Value for 'seriesColors' cannot be parsed");
                    }
                    this.seriesColors = value;
                    continue;
                }
                if (child.getLocalName().equals("sectionColors")) {
                    value = this.getValue(child);
                    if (value == null) {
                        throw new XPathException("Value for 'sectionColors' cannot be parsed");
                    }
                    this.sectionColors = value;
                    continue;
                }
                if (child.getLocalName().equals("sectionColorsDelimiter")) {
                    value = this.getValue(child);
                    if (value == null) {
                        throw new XPathException("Value for 'sectionColorsDelimiter' cannot be parsed");
                    }
                    this.sectionColorsDelimiter = value;
                    continue;
                }
                if (child.getLocalName().equals("rangeLowerBound")) {
                    value = this.parseDouble(this.getValue(child));
                    if (value == null) {
                        throw new XPathException("Value for 'rangeLowerBound' cannot be parsed");
                    }
                    this.rangeLowerBound = value;
                    continue;
                }
                if (child.getLocalName().equals("rangeUpperBound")) {
                    value = this.parseDouble(this.getValue(child));
                    if (value == null) {
                        throw new XPathException("Value for 'rangeUpperBound' cannot be parsed");
                    }
                    this.rangeUpperBound = value;
                    continue;
                }
                if (child.getLocalName().equals("categoryItemLabelGeneratorClass")) {
                    value = this.getValue(child);
                    if (value == null) {
                        throw new XPathException("Value for 'categoryItemLabelGeneratorClass' cannot be parsed");
                    }
                    this.categoryItemLabelGeneratorClass = value;
                    continue;
                }
                if (child.getLocalName().equals("categoryItemLabelGeneratorParameter")) {
                    value = this.getValue(child);
                    if (value == null) {
                        throw new XPathException("Value for 'categoryItemLabelGeneratorParameter' cannot be parsed");
                    }
                    this.categoryItemLabelGeneratorParameter = value;
                    continue;
                }
                if (child.getLocalName().equals("categoryItemLabelGeneratorNumberFormat")) {
                    value = this.getValue(child);
                    if (value == null) {
                        throw new XPathException("Value for 'categoryItemLabelGeneratorNumberFormat' cannot be parsed");
                    }
                    this.categoryItemLabelGeneratorNumberFormat = value;
                    continue;
                }
                if (!child.getLocalName().equals("imageType")) continue;
                value = this.getValue(child);
                if (value == null) {
                    throw new XPathException("Value for 'imageType' cannot be parsed");
                }
                this.imageType = value;
            }
        }
    }

    private Boolean parseBoolean(String value) {
        if (value == null) {
            return null;
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no")) {
            return false;
        }
        return null;
    }

    private Integer parseInteger(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException ex) {
            logger.debug((Object)ex.getMessage());
            return null;
        }
    }

    private Double parseDouble(String value) {
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException ex) {
            logger.debug((Object)ex.getMessage());
            return null;
        }
    }

    private String getValue(Node child) {
        return child.getFirstChild().getNodeValue();
    }
}

